#include "Affiliation.h"
#include "ConferenceDB.h"
#include <algorithm>

Affiliation::Affiliation(const std::string& strName, 
                     const std::string& strAddress) : 
Indexable(),
m_strName(strName),
m_strAddress(strAddress)
{
}

Affiliation::Affiliation(std::istream& stream) : 
Indexable()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void Affiliation::SerializeValues(std::string& serializationString) const {  
  Indexable::SerializeValues(serializationString);
  AddSerialization(serializationString, m_strName);
  AddSerialization(serializationString, m_strAddress);
}

bool Affiliation::DeserializeValues(std::istream& stream) {
  if (!Indexable::DeserializeValues(stream)) return false;
  if (!DeserializeValue(stream, m_strName)) return false;
  return DeserializeValue(stream, m_strAddress);
}

unsigned int Affiliation::Replace(const Affiliation& newAff, ConferenceDB* confDB) const {
    unsigned int refs = 0;
    for (size_t i = 0;i<confDB->people.Count();++i) {
      SciPerson* potentialPerson = confDB->people.GetEntryByPos(i);
      refs += potentialPerson->ReplaceAffiliation(*this, newAff);
    }
    return refs;
}

unsigned int Affiliation::GetReferenceCount(const ConferenceDB* confDB) const {
  unsigned int refs = 0;
  for (size_t i = 0;i<confDB->people.Count();++i) {
    const SciPerson* potentialPerson = confDB->people.GetEntryByPos(i);    
    const std::vector<index_t>& aff = potentialPerson->GetAffiliations();
    if (std::find(aff.begin(), aff.end(), m_iIndex) != aff.end() ) {
      refs++;
    }
  }
  return refs;
}
