#ifndef AFFILIATION_H
#define AFFILIATION_H

#include "Indexable.h"

class Affiliation : public Indexable {
public:
  Affiliation(const std::string& strName, 
              const std::string& strAddress);
  
  Affiliation(std::istream& stream);
    
  const std::string& GetName() const {return m_strName;}
  const std::string& GetAddress() const {return m_strAddress;}
  
  void SetName(const std::string& strName)  {m_strName = strName;}
  void SetAddress(const std::string& strAddress)  {m_strAddress = strAddress;}
  
  static std::string GetClassName() {return "Affiliation";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  virtual bool Validate(const ConferenceDB*) const {return true;}
  unsigned int GetReferenceCount(const ConferenceDB* confDB) const;
  unsigned int Replace(const Affiliation& newAff, ConferenceDB* confDB) const;

  bool operator==(const Affiliation &other) const {
    return other.m_strName == m_strName &&
           other.m_strAddress == m_strAddress;
  }

protected:
  Affiliation() : Indexable() {}
  
  std::string m_strName;
  std::string m_strAddress;

  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // AFFILIATION_H
