#ifndef CSFPARSER_H
#define CSFPARSER_H

#include <vector>
#include <iostream>

class CSFParser {
public:
  CSFParser(const std::string& filename, size_t offset=0, bool bRemoveWhitespaces=false);
  CSFParser(std::istream& stream, size_t offset=0, bool bRemoveWhitespaces=false);

  size_t SetRecordSizeToMax();
  void SetVariableRecordSize();
  void SetRecordSize(size_t iSize);
  size_t RecordCount() const {return m_IndexMapping.size();}
  const std::vector< std::string >& GetRecord(size_t i) const;

  const std::vector< std::vector< std::string > >& GetParsedData() const {return m_RawParsedData;}

protected:
  std::vector< size_t > m_IndexMapping;
  std::vector< std::vector< std::string > > m_RawParsedData;
  size_t m_offset;
  bool m_bRemoveWhitespaces;

  void ParseStream(std::istream& stream);
  void ParseLine(const std::string& line);

  std::string TrimStrLeft( const std::string& Src, const std::string& c);
  std::string TrimStrRight( const std::string& Src, const std::string& c);
  std::string TrimStr( const std::string& Src, const std::string& c = " \r\n\t");
  std::string cleanup(const std::string& str);
};


#endif // CSFPARSER_H
