#ifndef CONFERENCEUSERDATA_H
#define CONFERENCEUSERDATA_H

#include "ConferenceDB.h"

class SciWork;
class PaperTalk;

// selected talks per day (sorted by days and sorted within each day)

class PersEntry {
public:
  PersEntry(index_t _index, bool _bIsTalk) :
  index(_index),
  bIsTalk(_bIsTalk) 
  {}

  bool operator==(const PersEntry &other) const {
    return other.index == index && other.bIsTalk == bIsTalk;
  }
  
  index_t index;
  bool bIsTalk;
};

typedef std::pair<index_t, std::vector<PersEntry> >PersonalDay;
typedef std::vector< PersonalDay > PersonalSchedule;

class ConferenceUsedata : public Serializable {
public:
  ConferenceUsedata(std::istream& stream) :
  Serializable()
  {
    m_bDeserializationSuccess = Deserialize(stream);
  }
  
  const std::string GetFilename() const {return m_strFilename;}
  
  static ConferenceUsedata* CreateOrLoadConferenceUsedataForConferenceDB(const ConferenceDB& confDB, const std::string& dbDirectory);
  
  const SciWork* AddPaperWithPaperID(index_t paperID, const ConferenceDB* confDB);
  const PaperTalk* AddScheduleEntryWithPaperID(index_t paperID, const ConferenceDB* confDB);
  void RemoveScheduleEntryWithPaperID(index_t paperID, const ConferenceDB* confDB);

  bool AddScheduleEntry(PersEntry entry, const ConferenceDB* confDB=0); // confDB=0 skips validation of indices                                 
  size_t PaperCount() const {return m_vSelectedPapers.size();}
  size_t ScheduleEntryCount() const {return m_vSelectedScheduleEntries.size();}

  PersonalSchedule GetPersonalSchedule(const ConferenceDB* confDB);
  
  index_t GetPaper(size_t index) const {return m_vSelectedPapers[index];}
  PersEntry GetScheduleEntry(size_t index) const {return m_vSelectedScheduleEntries[index];}
  void RemovePaper(index_t paper_index);
  void RemoveScheduleEntry(PersEntry entry);
  
  void ValidateAndFix(const ConferenceDB* confDB);
  
protected:
  ConferenceUsedata() : Serializable() {
  }
  
  std::string m_strFilename;
  std::vector<PersEntry> m_vSelectedScheduleEntries;
  std::vector<index_t> m_vSelectedPapers;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
  bool Save();
  
};

#endif // CONFERENCEUSERDATA_H
