#include "Indexable.h"


IndexGenerator::IndexGenerator() : 
Serializable(), 
m_iMinIndex(INDEX_EMPTY) 
{
}

IndexGenerator::IndexGenerator(index_t iStartIndex) : 
Serializable(), 
m_iMinIndex(iStartIndex) 
{
}

IndexGenerator::IndexGenerator(std::istream& stream) :
Serializable() 
{
  Deserialize(stream);
}

IndexGenerator::IndexGenerator(CIndexedVectorIter& iStart, 
                               CIndexedVectorIter& iEnd) :
Serializable(),
m_iMinIndex(INDEX_EMPTY) 
{
  for(CIndexedVectorIter iter = iStart; iter != iEnd; ++iter) {
    m_iMinIndex = std::max((*iter)->GetIndex(), m_iMinIndex);
  }
}

void IndexGenerator::SerializeValues(std::string& serializationString) const {
  AddSerialization(serializationString, m_iMinIndex);
}

bool IndexGenerator::DeserializeValues(std::istream& stream) {
  return DeserializeValue(stream, m_iMinIndex);  
}
