#include <algorithm>

#include "Keynote.h"
#include "ConferenceDB.h"

Keynote::Keynote(const std::string& strTitle,
                 const int iStartTime,
                 const int iEndTime,
                 const bool bIsCapstone) :
Session(strTitle,iStartTime,iEndTime,GetClassName()),
m_bIsCapstone(bIsCapstone)
{
}

Keynote::Keynote(const std::string& strTitle,
                 const int iStartTime,
                 const int iEndTime,
                 const SciPerson& sessionChair,
                 const bool bChairAcceptsMail,
                 const bool bIsCapstone) :
Session(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail,GetClassName()),
m_bIsCapstone(bIsCapstone)
{
}

Keynote::Keynote(const std::string& strTitle, 
                 const int iStartTime,
                 const int iEndTime,
                 const SciPerson& sessionChair,
                 const bool bChairAcceptsMail,
                 const bool bIsCapstone, 
                 const std::vector<index_t>& vLocations,
                 const std::vector<index_t>& vInvitedTalks) :
Session(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail,GetClassName(),vLocations),
m_vInvitedTalks(vInvitedTalks),
m_bIsCapstone(bIsCapstone)
{
}

Keynote::Keynote(std::istream& stream) :
Session()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void Keynote::SerializeValues(std::string& serializationString) const {
  Session::SerializeValues(serializationString);
  AddVectorSerialization(serializationString, m_vInvitedTalks);
  AddSerialization(serializationString, m_bIsCapstone);
}

bool Keynote::DeserializeValues(std::istream& stream) {
  if (!Session::DeserializeValues(stream)) return false;
  if (!DeserializeVector(stream, m_vInvitedTalks)) return false;
  if (!DeserializeValue(stream, m_bIsCapstone)) return false;
  return true;
}

void Keynote::DelInvitedTalk(index_t index) {
    for (size_t i = 0;i<m_vInvitedTalks.size();++i) {
      if (m_vInvitedTalks[i] == index)
        m_vInvitedTalks.erase(m_vInvitedTalks.begin()+i);
    }
}

bool Keynote::Contains(const Talk* t) const {
  index_t index = t->GetIndex();
  if (std::find(m_vInvitedTalks.begin(), m_vInvitedTalks.end(), index) != m_vInvitedTalks.end() ) {
    return true;
  }
  return false;
}

bool Keynote::Validate(const ConferenceDB* confDB) const {
  if (!Session::Validate(confDB)) return false;
  
  for (size_t i = 0;i<m_vInvitedTalks.size();++i) {
    const Talk* t = confDB->talks.GetEntryByIndex(m_vInvitedTalks[i]);
    if (!t || !dynamic_cast<const InvitedTalk*>(t)) return false;
  }  
  return true;
}
