#include "MetaDB.h"


ServerConferenceFileMD::ServerConferenceFileMD(const std::string& strTitle, 
                                               const std::string& strShortTitle, 
                                               int iVersion, 
                                               const std::string& strFilename, 
                                               const std::vector<uint8_t>& vMD5Hash):
Serializable(),
m_strTitle(strTitle),
m_strShortTitle(strShortTitle),
m_iVersion(iVersion),
m_strFilename(strFilename),
m_vMD5Hash(vMD5Hash)
{
}

ServerConferenceFileMD::ServerConferenceFileMD(std::istream& stream) :
Serializable()
{
  m_bDeserializationSuccess = Deserialize(stream);  
}

void ServerConferenceFileMD::SerializeValues(std::string& serializationString) const {
  AddSerialization(serializationString, m_strTitle);
  AddSerialization(serializationString, m_strShortTitle);  
  AddSerialization(serializationString, m_iVersion);
  AddSerialization(serializationString, m_strFilename);
  AddSerialization(serializationString, MD5::ToHexString(m_vMD5Hash));  
}

bool ServerConferenceFileMD::DeserializeValues(std::istream& stream) {
  if (!DeserializeValue(stream, m_strTitle)) return false;
  if (!DeserializeValue(stream, m_strShortTitle)) return false;
  if (!DeserializeValue(stream, m_iVersion)) return false;
  if (!DeserializeValue(stream, m_strFilename)) return false;
  
  std::string hashString;
  if (!DeserializeValue(stream, hashString)) return false;
  m_vMD5Hash = MD5::ToHash(hashString);
  return !m_vMD5Hash.empty();
}

LocalConferenceFileMD::LocalConferenceFileMD(const std::string& strTitle, 
                                             const std::string& strShortTitle, 
                                             int iVersion):
Serializable(),
m_strTitle(strTitle),
m_strShortTitle(strShortTitle),
m_iVersion(iVersion),
m_bDownloaded(true), // for now all conferences are downlaoded so this is always true
m_strDirectory("")
{
}

LocalConferenceFileMD::LocalConferenceFileMD(std::istream& stream) :
Serializable()
{
  m_bDeserializationSuccess = Deserialize(stream);  
}

void LocalConferenceFileMD::SerializeValues(std::string& serializationString) const {
  AddSerialization(serializationString, m_strTitle);
  AddSerialization(serializationString, m_strShortTitle);
  AddSerialization(serializationString, m_iVersion);
  AddSerialization(serializationString, m_strDirectory);
  AddSerialization(serializationString, m_bDownloaded);
}

bool LocalConferenceFileMD::DeserializeValues(std::istream& stream) {
  if (!DeserializeValue(stream, m_strTitle)) return false;
  if (!DeserializeValue(stream, m_strShortTitle)) return false;
  if (!DeserializeValue(stream, m_iVersion)) return false;
  if (!DeserializeValue(stream, m_strDirectory)) return false;
  return DeserializeValue(stream, m_bDownloaded);
}