#ifndef METADB_H
#define METADB_H

#include "Serializable.h"
#include "MD5.h"

#define CONFERENCE_METADATA_VERSION 1

template <class T> class MetaDB : public Serializable  {
public:
  MetaDB() :
  Serializable(),
  m_iMetaDataVersion(CONFERENCE_METADATA_VERSION)
  {
  }
  
  MetaDB(const std::string& strFilename) :
  Serializable(),
  m_iMetaDataVersion(CONFERENCE_METADATA_VERSION)
  {
    std::ifstream stream;
    stream.open(strFilename.c_str());
    if (!stream.is_open()) {
      m_bDeserializationSuccess = false;
      return;
    }
    
    m_bDeserializationSuccess = Deserialize(stream); 
    
    stream.close();
  }
  
  MetaDB(std::istream& stream) :
  Serializable(),
  m_iMetaDataVersion(CONFERENCE_METADATA_VERSION)
  {
    m_bDeserializationSuccess = Deserialize(stream); 
  }
  
  int m_iMetaDataVersion;
  std::vector<T> m_ConfFiles;  
  
protected:
  virtual void SerializeValues(std::string& serializationString) const {
    AddSerialization(serializationString, m_iMetaDataVersion);
    AddClassVectorSerialization(serializationString, m_ConfFiles);
  }
  
  virtual bool DeserializeValues(std::istream& stream) {
    if (!DeserializeValue(stream, m_iMetaDataVersion)) return false;
    if (m_iMetaDataVersion != CONFERENCE_METADATA_VERSION) return false;
      
    return DeserializeClassVector(stream, m_ConfFiles);
  }
  
};

class ServerConferenceFileMD : public Serializable {
public:  
  ServerConferenceFileMD(const std::string& strTitle, 
                         const std::string& strShortTitle, 
                         int m_iVersion, 
                         const std::string& strFilename, 
                         const MD5Hash& vMD5Hash);
  
  ServerConferenceFileMD(std::istream& stream);  
  
  std::string m_strTitle;
  std::string m_strShortTitle;  
  int m_iVersion;
  std::string m_strFilename;
  MD5Hash m_vMD5Hash;
  
protected:
  virtual void SerializeValues(std::string& serializationString) const;  
  virtual bool DeserializeValues(std::istream& stream);
  
};

typedef MetaDB<ServerConferenceFileMD> ServerMetaDB;

class LocalConferenceFileMD : public Serializable {
public:  
  LocalConferenceFileMD(const std::string& strTitle, 
                        const std::string& strShortTitle, 
                        int m_iVersion);
  
  LocalConferenceFileMD(std::istream& stream);  
  
  std::string m_strTitle;
  std::string m_strShortTitle;
  int m_iVersion;
  bool m_bDownloaded;
  
protected:
  std::string m_strDirectory; // no used only here for compatibility

  virtual void SerializeValues(std::string& serializationString) const;  
  virtual bool DeserializeValues(std::istream& stream);
  
};

typedef MetaDB<LocalConferenceFileMD> LocalMetaDB;


#endif // METADB_H