#include "NewsDB.h"
#include "ConferenceDB.h"

NewsDB::NewsDB() : 
Serializable(),
m_strFilename(""),
m_iCounter(0)
{
}

NewsDB::NewsDB(const std::string& filename) : 
Serializable(),
m_strFilename(""),
m_iCounter(0)
{
  m_strFilename = filename;
  std::ifstream stream;
  stream.open(filename.c_str());
  if (stream.is_open()) {
    m_bDeserializationSuccess = Deserialize(stream);
    stream.close();    
  } else {
    m_bDeserializationSuccess = false;
  }
}

NewsDB::NewsDB(std::istream& stream) :
Serializable(),
m_strFilename(""),
m_iCounter(0)
{
  m_bDeserializationSuccess = Deserialize(stream);
}

bool NewsDB::Save() {
  if (m_strFilename.empty()) return false;
  return SerializeFile(m_strFilename);
}

bool NewsDB::Import(const NewsDB& other) 
{
  bool bChanged = false;
  for (size_t i = 0;i<other.m_vNews.size();++i) {
    bool bFound = false;
    for (size_t j = 0;j<m_vNews.size();++j) {
      if (other.m_vNews[i].m_iNewsID == m_vNews[j].m_iNewsID) {
        bFound = true;
        break;
      }
    }
    if (!bFound) {
      AddNewsItem(other.m_vNews[i]);
      bChanged = true;
    }
  }  
  return bChanged;
}


void NewsDB::RemoveNewsItemWithIndex(index_t index) {
  for (size_t j = 0;j<m_vNews.size();++j) {
    if (m_vNews[j].m_iNewsID == index) {
      RemoveNewsItemWithPos(j);
      return;
    }
  }  
}

size_t NewsDB::UnreadCount() const {
  size_t iCount = 0;
  for (size_t i = 0;i<m_vNews.size();++i) {
    if (!m_vNews[i].m_bRead && m_vNews[i].m_bVisible) ++iCount;
  }
  return iCount;
}

size_t NewsDB::Count() const {
  size_t iCount = 0;
  for (size_t i = 0;i<m_vNews.size();++i) {
    if (m_vNews[i].m_bVisible) ++iCount;
  }
  return iCount;
}

void NewsDB::SerializeValues(std::string& serializationString) const {
  AddSerialization(serializationString, m_iCounter);
  AddClassVectorSerialization(serializationString, m_vNews);
}

bool NewsDB::DeserializeValues(std::istream& stream) {
  if (!DeserializeValue(stream, m_iCounter)) return false;
  return DeserializeClassVector(stream, m_vNews);
}

size_t NewsDB::GetVisibleIndex(size_t index) const {
  for (size_t i = 0;i<m_vNews.size();++i) {
    if (m_vNews[i].m_bVisible) {
      if (index == 0) 
        return i;
      else
        --index;
    }
  }
  return -1;
}


NewsItem::NewsItem(int ID, const std::string& strTitle, const std::string& strText, unsigned int iTime, unsigned int iDay, unsigned int iMonth, int iYear, bool bRead, bool bVisible) :
Serializable(),
m_iNewsID(ID),
m_NewsTitle(strTitle),
m_NewsText(strText),
m_iTime(iTime),
m_iDay(iDay),
m_iMonth(iMonth),
m_iYear(iYear),
m_bRead(bRead),
m_bVisible(bVisible)
{
}

NewsItem::NewsItem(std::istream& stream) :
Serializable()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void NewsItem::SerializeValues(std::string& serializationString) const {
  AddSerialization(serializationString, m_iNewsID);
  AddSerialization(serializationString, m_NewsTitle);
  AddSerialization(serializationString, m_NewsText);
  AddSerialization(serializationString, m_iTime);
  AddSerialization(serializationString, m_iDay);
  AddSerialization(serializationString, m_iMonth);
  AddSerialization(serializationString, m_iYear);
  AddSerialization(serializationString, m_bRead);
  AddSerialization(serializationString, m_bVisible);
}

bool NewsItem::DeserializeValues(std::istream& stream) {
  if (!DeserializeValue(stream, m_iNewsID)) return false;
  if (!DeserializeValue(stream, m_NewsTitle)) return false;
  if (!DeserializeValue(stream, m_NewsText)) return false;
  if (!DeserializeValue(stream, m_iTime)) return false;
  if (!DeserializeValue(stream, m_iDay)) return false;
  if (!DeserializeValue(stream, m_iMonth)) return false;
  if (!DeserializeValue(stream, m_iYear)) return false;
  if (!DeserializeValue(stream, m_bRead)) return false;
  if (!DeserializeValue(stream, m_bVisible)) return false;
  return true;
}
