#ifndef NEWSDB_H
#define NEWSDB_H

#include "Indexable.h"

class NewsItem : public Serializable {
public:
  NewsItem(int ID, const std::string&  strTitle, const std::string&  strText, unsigned int iTime, unsigned int iDay, unsigned int iMonth, int iYear, bool bRead, bool bVisible);
  NewsItem(std::istream& stream);
  
  index_t      m_iNewsID;
  std::string  m_NewsTitle;
  std::string  m_NewsText;
  unsigned int m_iTime;
  unsigned int m_iDay;
  unsigned int m_iMonth;
  int          m_iYear;
  bool         m_bRead;
  bool         m_bVisible;
  
protected:  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
};

class NewsDB : public Serializable {
public:
  NewsDB();
  NewsDB(const std::string& filename);
  NewsDB(std::istream& stream);

  bool Save();
  bool Import(const NewsDB& other);
  
  size_t Count() const;
  size_t CountAll() const {return m_vNews.size();}
  size_t UnreadCount() const;
  void MarkRead(size_t index) {m_vNews[GetVisibleIndex(index)].m_bRead = true;}
  void Hide(size_t index) {m_vNews[GetVisibleIndex(index)].m_bVisible = false;}
  const NewsItem& GetNewsItem(size_t index) const {return m_vNews[GetVisibleIndex(index)];}
  NewsItem& GetNewsItemAll(size_t index) {return m_vNews[index];}
  void SetNews(const std::vector<NewsItem>& vNews)  {m_vNews = vNews;}
  void AddNewsItem(const NewsItem& item)  {m_vNews.push_back(item); m_vNews[m_vNews.size()-1].m_bRead = false;}
  void RemoveNewsItemWithPos(size_t pos) {m_vNews.erase(m_vNews.begin()+GetVisibleIndex(pos));}
  void RemoveNewsItemWithIndex(index_t index);
  unsigned int GetIndex() {return ++m_iCounter;}
  
protected:
  std::string m_strFilename;
  
  index_t m_iCounter;
  std::vector<NewsItem> m_vNews;
  
  size_t GetVisibleIndex(size_t index) const;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};

#endif // NEWSDB_H