#include "OrganizedSession.h"
#include "ConferenceDB.h"

OrganizedSession::OrganizedSession(const std::string& strTitle,
                                   const int iStartTime,
                                   const int iEndTime,
                                   const std::string& strSessionDesc,
                                   const std::string& strAbstract) :
Session(strTitle,iStartTime,iEndTime,strSessionDesc),
m_strAbstract(strAbstract)
{
}

OrganizedSession::OrganizedSession(const std::string& strTitle,
                                   const int iStartTime,
                                   const int iEndTime,
                                   const SciPerson& sessionChair,
                                   const bool bChairAcceptsMail,
                                   const std::string& strSessionDesc, 
                                   const std::string& strAbstract) :
Session(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail,strSessionDesc),
m_strAbstract(strAbstract)
{
}

OrganizedSession::OrganizedSession(const std::string& strTitle, 
                                   const int iStartTime,
                                   const int iEndTime,
                                   const SciPerson& sessionChair,
                                   const bool bChairAcceptsMail, 
                                   const std::string& strSessionDesc, 
                                   const std::string& strAbstract,
                                   const std::vector<index_t>& vOrganizers, 
                                   const std::vector<index_t>& vLocations) :
Session(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail,strSessionDesc,vLocations),
m_strAbstract(strAbstract),
m_vOrganizers(vOrganizers)
{
}

OrganizedSession::OrganizedSession(std::istream& stream) :
Session()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void OrganizedSession::SerializeValues(std::string& serializationString) const {
  Session::SerializeValues(serializationString);
  AddSerialization(serializationString, m_strAbstract);
  AddVectorSerialization(serializationString, m_vOrganizers);
}

bool OrganizedSession::DeserializeValues(std::istream& stream) {
  if (!Session::DeserializeValues(stream)) return false;
  if (!DeserializeValue(stream, m_strAbstract)) return false;
  if (!DeserializeVector(stream, m_vOrganizers)) return false;
  return true;
}

void OrganizedSession::DelOrganizer(index_t index) {
    for (size_t i = 0;i<m_vOrganizers.size();++i) {
      if (m_vOrganizers[i] == index)
        m_vOrganizers.erase(m_vOrganizers.begin()+i);
    }
}

unsigned int OrganizedSession::ReplaceOrganizer(const SciPerson& person, const SciPerson& newPerson) {
    unsigned int refs = 0;
    index_t personIndex = person.GetIndex();
    for (size_t i = 0;i<m_vOrganizers.size();++i) {
      if (m_vOrganizers[i] == personIndex) {
        m_vOrganizers[i] = newPerson.GetIndex();
        ++refs;
      }
    }
    return refs;
}

bool OrganizedSession::Validate(const ConferenceDB* confDB) const {
  if (! Session::Validate(confDB) ) return false;    
  
  for (size_t i = 0;i<m_vOrganizers.size();++i) {
    if (! confDB->people.GetEntryByIndex(m_vOrganizers[i]) ) return false;
  }  
  return true;
}
