#ifndef PAPER_H
#define PAPER_H

#include "SciWork.h"
#include "StringList.h"

class PaperTalk;

class Paper : public SciWork {
public:
  Paper(const std::string& strTitle, 
        const std::string& strAbstract,         
        const std::string& strURL, 
        const std::string& strPreviewURL, 
        const std::string& strPDFURL);
  
  Paper(const std::string& strTitle,
        const std::string& strAbstract,         
        const std::string& strURL, 
        const std::string& strPreviewURL, 
        const std::string& strPDFURL, 
        const std::vector<index_t>& vAuthors);
         
  Paper(std::istream& stream);
  const PaperTalk* FindContainingTalk(const ConferenceDB* confDB) const;  
  
  virtual std::string GetWorkType() {return StringList::strPaper;} 
  
  static std::string GetClassName() {return "Paper";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  unsigned int GetReferenceCount(const ConferenceDB* confDB) const;
  unsigned int Replace(const Paper& newPaper, ConferenceDB* confDB) const;

  bool operator==(const Paper &other) const {
    return SciWork::operator==(other);
  }

protected:
  Paper() : SciWork() {}

  virtual void SerializeValues(std::string& serializationString) const;  
  virtual bool DeserializeValues(std::istream& stream);
};

#endif // PAPER_H
