#include <algorithm>

#include "PaperSession.h"
#include "ConferenceDB.h"

PaperSession::PaperSession(const std::string& strTitle,
                           const int iStartTime,
                           const int iEndTime) :
Session(strTitle,iStartTime,iEndTime,GetClassName())
{
}

PaperSession::PaperSession(const std::string& strTitle, 
                           const int iStartTime,
                           const int iEndTime,
                           const SciPerson& sessionChair,
                           const bool bChairAcceptsMail) :
Session(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail,GetClassName())
{
}

PaperSession::PaperSession(const std::string& strTitle, 
                           const int iStartTime,
                           const int iEndTime,
                           const SciPerson& sessionChair,
                           const bool bChairAcceptsMail, 
                           const std::vector<index_t>& vLocations,
                           const std::vector<index_t>& vPaperTalks) :
Session(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail,GetClassName(),vLocations),
m_vPaperTalks(vPaperTalks)
{
}

PaperSession::PaperSession(std::istream& stream) :
Session()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void PaperSession::SerializeValues(std::string& serializationString) const {
  Session::SerializeValues(serializationString);
  AddVectorSerialization(serializationString, m_vPaperTalks);
}

bool PaperSession::DeserializeValues(std::istream& stream) {
  if (!Session::DeserializeValues(stream)) return false;
  return DeserializeVector(stream, m_vPaperTalks);
}

void PaperSession::DelPaperTalk(index_t index) {
    for (size_t i = 0;i<m_vPaperTalks.size();++i) {
      if (m_vPaperTalks[i] == index)
        m_vPaperTalks.erase(m_vPaperTalks.begin()+i);
    }
}


bool PaperSession::Contains(const Talk* t) const {
  index_t index = t->GetIndex();
  if (std::find(m_vPaperTalks.begin(), m_vPaperTalks.end(), index) != m_vPaperTalks.end() ) {
    return true;
  }
  return false;
}

bool PaperSession::Validate(const ConferenceDB* confDB) const {
  if (!Session::Validate(confDB)) return false;
  
  for (size_t i = 0;i<m_vPaperTalks.size();++i) {
    const Talk* t = confDB->talks.GetEntryByIndex(m_vPaperTalks[i]);
    if (!t || !dynamic_cast<const PaperTalk*>(t)) return false;
  }  
  return true;
}
