#include "PaperTalk.h"
#include "ConferenceDB.h"

PaperTalk::PaperTalk(const std::string& strTitle,
                     const int iStartTime,
                     const int iEndTime) :
Talk(strTitle, iStartTime, iEndTime),
m_iPaper(0)
{
}

PaperTalk::PaperTalk(const std::string& strTitle, 
                     const int iStartTime,
                     const int iEndTime,
                     const Paper& paper) :
Talk(strTitle, iStartTime, iEndTime),
m_iPaper(paper.GetIndex())
{
}

PaperTalk::PaperTalk(const std::string& strTitle, 
                     const std::vector<index_t>& vSpeakers,
                     const int iStartTime,
                     const int iEndTime,
                     const Paper& paper) :
Talk(strTitle, vSpeakers, iStartTime, iEndTime),
m_iPaper(paper.GetIndex())
{
}

PaperTalk::PaperTalk(std::istream& stream) :
Talk()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void PaperTalk::SerializeValues(std::string& serializationString) const {
  Talk::SerializeValues(serializationString);
  AddSerialization(serializationString, m_iPaper);
}

bool PaperTalk::DeserializeValues(std::istream& stream) {
  if (!Talk::DeserializeValues(stream)) return false;
  return DeserializeValue(stream, m_iPaper);
}

bool PaperTalk::Validate(const ConferenceDB* confDB) const {
  if (!Talk::Validate(confDB))
      return false;
  if (m_iPaper != 0 && !confDB->works.GetEntryByIndex(m_iPaper)) {
      return false;
  }
  return true;
}
