#ifndef PAPERTALK_H
#define PAPERTALK_H

#include "Talk.h"
#include "Paper.h"

class PaperTalk : public Talk {
public:
  PaperTalk(const std::string& strTitle,
              const int iStartTime,
              const int iEndTime);

  PaperTalk(const std::string& strTitle,
            const int iStartTime,
            const int iEndTime,
            const Paper& paper);
  
  PaperTalk(const std::string& strTitle, 
            const std::vector<index_t>& vSpeakers,
            const int iStartTime,
            const int iEndTime,
            const Paper& paper);
  
  PaperTalk(std::istream& stream);
    
  index_t GetPaper() const {return m_iPaper;}  
  void ClearPaper() {m_iPaper = 0;}
  void SetPaper(const Paper& paper)  {m_iPaper = paper.GetIndex(); }
  
  virtual std::string GetTalkType() {return "Paper Talk";}
  
  static std::string GetClassName() {return "PaperTalk";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  virtual bool Validate(const ConferenceDB* confDB) const;
  
  bool operator==(const PaperTalk &other) const {
    return other.m_iPaper == m_iPaper &&
           Talk::operator==(other);
  }

protected:
  PaperTalk() : Talk() {}
  
  index_t m_iPaper;
  
  virtual void SerializeValues(std::string& serializationString) const;  
  virtual bool DeserializeValues(std::istream& stream);
};


#endif // PAPERTALK_H
