#ifndef POSTER_H
#define POSTER_H

#include "SciWork.h"
#include "StringList.h"

class PosterSession;

class Poster : public SciWork {
public:
  Poster(const std::string& strTitle, 
        const std::string& strAbstract,         
        const std::string& strURL, 
        const std::string& strPreviewURL, 
        const std::string& strPDFURL);
  
  Poster(const std::string& strTitle,
        const std::string& strAbstract,         
        const std::string& strURL, 
        const std::string& strPreviewURL, 
        const std::string& strPDFURL, 
        const std::vector<index_t>& vAuthors);
         
  Poster(std::istream& stream);
  const PosterSession* FindContainingSession(const ConferenceDB* confDB) const;  
  
  virtual std::string GetWorkType() {return StringList::strPoster;} 
  
  static std::string GetClassName() {return "Poster";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  unsigned int GetReferenceCount(const ConferenceDB* confDB) const;
  
  bool operator==(const Poster &other) const {
    return SciWork::operator==(other);
  }


protected:
  Poster() : SciWork() {}

  virtual void SerializeValues(std::string& serializationString) const;  
  virtual bool DeserializeValues(std::istream& stream);
};

#endif // POSTER_H
