#ifndef SCIWORK_H
#define SCIWORK_H

#include <string>
#include "Serializable.h"
#include "Indexable.h"
#include "SciPerson.h"

class SciWork : public Indexable {
public:
  SciWork(const std::string& strTitle, 
          const std::string& strAbstract, 
          const std::string& strURL, 
          const std::string& strPreviewURL, 
          const std::string& strPDFURL);
  
  SciWork(const std::string& strTitle, 
          const std::string& strAbstract, 
          const std::string& strURL, 
          const std::string& strPreviewURL, 
          const std::string& strPDFURL, 
          const std::vector<index_t>& vAuthors);
  
  SciWork(std::istream& stream);
  
  const std::string& GetTitle() const {return m_strTitle;}
  const std::vector<index_t>& GetAuthors() const {return m_vAuthors;}

  void SetTitle(const std::string& strTitle)  {m_strTitle = strTitle;}
  void SetAuthors(const std::vector<index_t>& vAuthors)  {m_vAuthors = vAuthors;}
  void AddAuthor(const SciPerson& author)  {m_vAuthors.push_back(author.GetIndex());}
  void AddAuthor(const index_t authorIndex)  {m_vAuthors.push_back(authorIndex);}
  void DelAuthor(const index_t authorIndex);
  void UpAuthor(const index_t authorIndex);
  void DownAuthor(const index_t authorIndex);
  unsigned int ReplaceAuthor(const SciPerson& author, const SciPerson& newAuthor);

  const std::string& GetAbstract() const {return m_strAbstract;}
  void SetAbstract(const std::string& strAbstract)  {m_strAbstract = strAbstract;}
  
  const std::string& GetURL() const {return m_strURL;}
  void SetURL(const std::string& strURL)  {m_strURL = strURL;}
  
  const std::string& GetPDFURL() const {return m_strPDFURL;}
  void SetPDFURL(const std::string& strURL)  {m_strPDFURL = strURL;}
  
  const std::string& GetPreviewURL() const {return m_strPreviewURL;}
  void SetPreviewURL(const std::string& strURL)  {m_strPreviewURL = strURL;}
  
  std::string GetDisplayAuthors(const ConferenceDB* db) const;
  
  virtual std::string GetWorkType() = 0;
  
  static std::string GetClassName() {return "SciWork";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  virtual bool Validate(const ConferenceDB* confDB) const;  
  
  bool operator==(const SciWork &other) const {
    return other.m_strTitle == m_strTitle &&
           other.m_strAbstract == m_strAbstract &&
           other.m_strURL == m_strURL &&
           other.m_strPreviewURL == m_strPreviewURL &&
           other.m_strPDFURL == m_strPDFURL &&
           other.m_vAuthors == m_vAuthors;
  }

protected:
  SciWork() : Indexable() {}
  std::string m_strTitle;
  std::string m_strAbstract;
  std::string m_strURL;
  std::string m_strPreviewURL;
  std::string m_strPDFURL;  
  std::vector<index_t> m_vAuthors;
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};

#endif // SCIWORK_H
