#ifndef SESSION_H
#define SESSION_H

#include "Room.h"
#include "SciPerson.h"
#include "Talk.h"

class Track;
class ConferenceDB;

class Session : public Indexable {
public:
  Session(const std::string& strTitle,
          const int iStartTime,
          const int iEndTime,
          const std::string& strDescription);

  Session(const std::string& strTitle,
          const int iStartTime,
          const int iEndTime,
          const SciPerson& sessionChair,
          const bool bChairAcceptsMail,
          const std::string& strDescription);
  
  Session(const std::string& strTitle,
          const int iStartTime,
          const int iEndTime,
          const SciPerson& sessionChair, 
          const bool bChairAcceptsMail,
          const std::string& strDescription,
          const std::vector<index_t>& vRooms);
  
  Session(std::istream& stream);
  
  const std::string& GetTitle() const {return m_strTitle;}
  const std::string& GetURL() const {return m_strURL;}
  const std::vector<index_t>& GetRooms() const {return m_vRooms;}
  int GetStartTime() const {return m_iStartTime;}
  int GetEndTime() const {return m_iEndTime;}
  index_t GetSessionChair() const {return m_SessionChair;}
  bool GetChairAcceptsMail() const {return m_bChairAcceptsMail;}
  const std::string& GetDescription() const {return m_strDescription;}
  void SetDescription(const std::string& strDescription)  {m_strDescription = strDescription;}
  
  void SetChairAcceptsMail(const bool bChairAcceptsMail)  {m_bChairAcceptsMail = bChairAcceptsMail;}   
  void SetSessionChair(const SciPerson& sessionChair)  {m_SessionChair = sessionChair.GetIndex();} 
  void ClearSessionChair() {m_SessionChair = 0;}
  void SetTitle(const std::string& strTitle)  {m_strTitle = strTitle;}
  void SetURL(const std::string& strURL)  {m_strURL = strURL;}
  void SetRooms(const std::vector<index_t>& vRooms)  {m_vRooms = vRooms;}
  void AddRoom(const Room& Room)  {m_vRooms.push_back(Room.GetIndex());}
  void DelRoom(index_t index);
  void SetStartTime(int time) { m_iStartTime = time; }
  void SetEndTime(int time) { m_iEndTime = time; }
  
  virtual std::string GetRoomsDisplayString(const ConferenceDB* confDB) const;
  virtual std::string GetSessionType() const {return GetClassName();}
  
  static std::string GetClassName() {return "Session";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
 
  const Track* FindContainingTrack(const ConferenceDB* confDB) const;
  unsigned int GetReferenceCount(const ConferenceDB* confDB) const;
  
  virtual bool Contains(const Talk*) const {return false;}
  virtual bool Validate(const ConferenceDB* confDB) const;

  bool operator==(const Session &other) const {
    return other.m_strTitle == m_strTitle &&
           other.m_strURL == m_strURL &&
           other.m_vRooms == m_vRooms &&
           other.m_iStartTime == m_iStartTime &&
           other.m_iEndTime == m_iEndTime &&
           other.m_SessionChair == m_SessionChair &&
           other.m_bChairAcceptsMail == m_bChairAcceptsMail &&
           other.m_strDescription == m_strDescription;
  }

protected:
  Session() : Indexable() {}
  
  std::string m_strTitle;
  std::string m_strURL;
  std::vector<index_t> m_vRooms;  
  int m_iStartTime;
  int m_iEndTime;
  index_t m_SessionChair;
  bool m_bChairAcceptsMail;
  std::string m_strDescription;    
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // SESSION_H
