#ifndef TRACK_H
#define TRACK_H

#include "Session.h"

class WorkDay;
class ConferenceDB;

class Track : public Indexable {
public:
  Track(const std::string& strTitle);
  
  Track(const std::string& strTitle, 
        const std::vector<index_t>& vSessions);
  
  Track(std::istream& stream);
  
  const std::string& GetTitle() const {return m_strTitle;}
  const std::vector<index_t>& GetSessions() const {return m_vSessions;}
  
  void SetTitle(const std::string& strTitle)  {m_strTitle = strTitle;}
  void SetSessions(const std::vector<index_t>& vSessions)  {m_vSessions = vSessions;}
  void AddSession(const Session& session)  {m_vSessions.push_back(session.GetIndex());}
  void DelSession(index_t index);
  
  int GetStartTime(const ConferenceDB* confDB) const;
  int GetEndTime(const ConferenceDB* confDB) const;
  
  const WorkDay* FindContainingDay(const ConferenceDB* confDB) const;
  
  static std::string GetClassName() {return "Track";} 
  virtual std::string GetClassNameViaObject() const {return GetClassName();} 
  
  virtual bool Validate(const ConferenceDB* confDB) const;
  virtual unsigned int GetReferenceCount(const ConferenceDB* confDB) const;
  unsigned int Replace(const Track& newTrack, ConferenceDB* confDB) const;

  bool operator==(const Track &other) const {
    return other.m_strTitle == m_strTitle &&
           other.m_vSessions == m_vSessions ;
  }

protected:
  Track() : Indexable() {}
  
  std::string m_strTitle;
  std::vector<index_t> m_vSessions;  
  
  virtual void SerializeValues(std::string& serializationString) const;
  virtual bool DeserializeValues(std::istream& stream);
  
};


#endif // TRACK_H
