#include <algorithm>

#include "Tutorial.h"
#include "ConferenceDB.h"
#include "StringList.h"


Tutorial::Tutorial(const std::string& strTitle,
                   const int iStartTime,
                   const int iEndTime,
                   const std::string& strAbstract) :
OrganizedSession(strTitle,iStartTime,iEndTime, StringList::strTutorial, strAbstract)
{
}

Tutorial::Tutorial(const std::string& strTitle,
                   const int iStartTime,
                   const int iEndTime,
                   const SciPerson& sessionChair,
                   const bool bChairAcceptsMail, 
                   const std::string& strAbstract) :
OrganizedSession(strTitle,iStartTime,iEndTime,sessionChair, bChairAcceptsMail, StringList::strTutorial, strAbstract)
{
}

Tutorial::Tutorial(const std::string& strTitle, 
                   const int iStartTime,
                   const int iEndTime,
                   const SciPerson& sessionChair,
                   const bool bChairAcceptsMail, 
                   const std::string& strAbstract, 
                   const std::vector<index_t>& vOrganizers,
                   const std::vector<index_t>& vLocations,
                   const std::vector<index_t>& vTutorialTalks) :
OrganizedSession(strTitle,iStartTime,iEndTime,sessionChair,bChairAcceptsMail, StringList::strTutorial, strAbstract, vOrganizers, vLocations),
m_vTutorialTalks(vTutorialTalks)
{
}

Tutorial::Tutorial(std::istream& stream) :
OrganizedSession()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void Tutorial::SerializeValues(std::string& serializationString) const {
  OrganizedSession::SerializeValues(serializationString);
  AddVectorSerialization(serializationString, m_vTutorialTalks);
}

bool Tutorial::DeserializeValues(std::istream& stream) {
  if (!OrganizedSession::DeserializeValues(stream)) return false;
  return DeserializeVector(stream, m_vTutorialTalks);
}

void Tutorial::DelTutorialTalk(index_t index) {
    for (size_t i = 0;i<m_vTutorialTalks.size();++i) {
      if (m_vTutorialTalks[i] == index)
        m_vTutorialTalks.erase(m_vTutorialTalks.begin()+i);
    }
}

bool Tutorial::Contains(const Talk* t) const {
  index_t index = t->GetIndex();
  if (std::find(m_vTutorialTalks.begin(), m_vTutorialTalks.end(), index) != m_vTutorialTalks.end() ) {
    return true;
  }
  return false;
}

bool Tutorial::Validate(const ConferenceDB* confDB) const {
  if (!Session::Validate(confDB)) return false;
  
  for (size_t i = 0;i<m_vTutorialTalks.size();++i) {
    const Talk* t = confDB->talks.GetEntryByIndex(m_vTutorialTalks[i]);
    if (!t || !dynamic_cast<const InvitedTalk*>(t)) return false;
  }  
  return true;
}
