#include "WorkDay.h"
#include "ConferenceDB.h"

WorkDay::WorkDay(const unsigned int iDay,
                 const unsigned int iMonth,
                 const int iYear) :
Indexable(),
m_iDay(iDay),
m_iMonth(iMonth),
m_iYear(iYear)
{
}

WorkDay::WorkDay(const unsigned int iDay,
                 const unsigned int iMonth,
                 const int iYear, 
                 const std::vector<index_t>& vTracks) :
Indexable(),
m_iDay(iDay),
m_iMonth(iMonth),
m_iYear(iYear),
m_vTracks(vTracks)
{
}

WorkDay::WorkDay(std::istream& stream) :
Indexable()
{
  m_bDeserializationSuccess = Deserialize(stream);
}

void WorkDay::SerializeValues(std::string& serializationString) const {
  Indexable::SerializeValues(serializationString);
  AddSerialization(serializationString, m_iDay);
  AddSerialization(serializationString, m_iMonth);
  AddSerialization(serializationString, m_iYear);
  AddVectorSerialization(serializationString, m_vTracks);
}

bool WorkDay::DeserializeValues(std::istream& stream) {
  if (!Indexable::DeserializeValues(stream)) return false;
  if (!DeserializeValue(stream, m_iDay)) return false;
  if (!DeserializeValue(stream, m_iMonth)) return false;
  if (!DeserializeValue(stream, m_iYear)) return false;
  if (!DeserializeVector(stream, m_vTracks)) return false;
  return true;
}

void WorkDay::DelTrack(index_t index) {
    for (size_t i = 0;i<m_vTracks.size();++i) {
        if (m_vTracks[i] == index)
            m_vTracks.erase(m_vTracks.begin()+i);
    }
}

unsigned int WorkDay::ReplaceTrack(const Track& track, const Track& newTrack) {
    index_t index = track.GetIndex();
    unsigned int iChanged = 0;
    for (size_t i = 0;i<m_vTracks.size();++i) {
        if (m_vTracks[i] == index) {
            m_vTracks[i] = newTrack.GetIndex();
            ++iChanged;
        }
    }
    return iChanged;
}


void WorkDay::GetStatistics(unsigned int& tracks, unsigned int& sessions, const ConferenceDB* pDB) const {
  tracks = m_vTracks.size();
  sessions = 0;  
  for (size_t i = 0;i<m_vTracks.size();++i) {
    const Track* t = pDB->tracks.GetEntryByIndex(m_vTracks[i]);
    t->GetSessions();    
    sessions += t->GetSessions().size();
  }  
}


bool WorkDay::Validate(const ConferenceDB* confDB) const {
  for (size_t i = 0;i<m_vTracks.size();++i) {
    if (! confDB->tracks.GetEntryByIndex(m_vTracks[i]) ) return false;
  }  
  return true;
}

unsigned int WorkDay::GetReferenceCount(const ConferenceDB*) const {
  return 1;
}

