#include "mainwindow.h"

#include <algorithm>
#include "QImportDialog.h"
#include <QtGui/QMessageBox>
#include <QtGui/QInputDialog>

void MainWindow::setupAffiliationsTab(){
    m_tabAffiliations = new QWidget();
    m_tabAffiliations->setObjectName(QString::fromUtf8("m_tabAffiliations"));
    m_tabAffiliations->setWindowTitle(QString::fromUtf8("Affiliations"));
    m_globalTabs->addTab(m_tabAffiliations, m_tabAffiliations->windowTitle());

    m_AffGlobalLayout = new QHBoxLayout(m_tabAffiliations);
    m_AffGlobalLayout->setSpacing(6);
    m_AffGlobalLayout->setContentsMargins(0, 0, 0, 0);
    m_AffGlobalLayout->setObjectName(QString::fromUtf8("m_TalkGlobalLayout"));
    m_AffSplitter = new QSplitter();
    m_AffGlobalLayout->addWidget(m_AffSplitter);

    m_AffListFrame = new QFrame(m_tabAffiliations);
    m_AffListFrame->setObjectName(QString::fromUtf8("m_AffListFrame"));
    m_AffListFrame->setFrameShape(QFrame::NoFrame);
    m_AffListFrame->setLineWidth(0);
    m_gridLayoutAffList = new QGridLayout(m_AffListFrame);
    m_gridLayoutAffList->setSpacing(6);
    m_gridLayoutAffList->setContentsMargins(0, 0, 0, 0);
    m_gridLayoutAffList->setObjectName(QString::fromUtf8("m_gridLayoutAffList"));

    m_AffImportBtn = new QPushButton(m_tabAffiliations);
    m_AffImportBtn->setText("Import Affiliations from CSV-File");
    m_gridLayoutAffList->addWidget(m_AffImportBtn, 0, 0, 1, 1);

    m_AffList = new QElemList(m_tabAffiliations, true);
    m_AffList->setObjectName(QString::fromUtf8("m_AffList"));
    m_gridLayoutAffList->addWidget(m_AffList, 1, 0, 1, 1);

    m_AffEditFrame = new QFrame(m_tabAffiliations);
    m_AffEditFrame->setObjectName(QString::fromUtf8("m_AffEditFrame"));
    m_AffEditFrame->setFrameShape(QFrame::NoFrame);
    m_AffEditFrame->setLineWidth(0);
    m_gridLayoutAff = new QGridLayout(m_AffEditFrame);
    m_gridLayoutAff->setSpacing(6);
    m_gridLayoutAff->setContentsMargins(0, 0, 0, 0);
    m_gridLayoutAff->setObjectName(QString::fromUtf8("m_gridLayoutAff"));

    m_AffNameLabel = new QLabel(m_AffEditFrame);
    m_AffNameLabel->setObjectName(QString::fromUtf8("m_AffNameLabel"));
    m_AffNameLabel->setText(QString::fromUtf8("Name"));
    m_gridLayoutAff->addWidget(m_AffNameLabel, 0, 0, 1, 1);
    m_AffNameEdit = new QLineEdit(m_AffEditFrame);
    m_AffNameEdit->setObjectName(QString::fromUtf8("m_AffNameEdit"));
    m_gridLayoutAff->addWidget(m_AffNameEdit, 0, 1, 1, 1);

    m_AffAddressLabel = new QLabel(m_AffEditFrame);
    m_AffAddressLabel->setObjectName(QString::fromUtf8("m_AffAddressLabel"));
    m_AffAddressLabel->setText(QString::fromUtf8("Address"));
    m_gridLayoutAff->addWidget(m_AffAddressLabel, 1, 0, 1, 1);
    m_AffAddressEdit = new QLineEdit(m_AffEditFrame);
    m_AffAddressEdit->setObjectName(QString::fromUtf8("m_AffAddressEdit"));
    m_gridLayoutAff->addWidget(m_AffAddressEdit, 1, 1, 1, 1);

    m_AffEditSpacer = new QSpacerItem(20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding);
    m_gridLayoutAff->addItem(m_AffEditSpacer, 2, 0, 1, 1);

    m_AffSplitter->addWidget(m_AffListFrame);
    m_AffSplitter->addWidget(m_AffEditFrame);

    QObject::connect(m_AffNameEdit, SIGNAL(textEdited(QString)), this, SLOT(affDataChanged()));
    QObject::connect(m_AffNameEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_AffAddressEdit, SIGNAL(textEdited(QString)), this, SLOT(affDataChanged()));
    QObject::connect(m_AffAddressEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));

    QObject::connect(m_AffList, SIGNAL(newElement()), this, SLOT(affNewElement()));
    QObject::connect(m_AffList, SIGNAL(newElement()), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_AffList, SIGNAL(delElement(index_t)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_AffList, SIGNAL(delElement(index_t)), this, SLOT(affDelElement(index_t)));
    QObject::connect(m_AffList, SIGNAL(activeElement(index_t)), this, SLOT(affActiveElement(index_t)));
    QObject::connect(m_AffList, SIGNAL(replaceElement(index_t)), this, SLOT(affReplaceElement(index_t)));

    QObject::connect(m_AffImportBtn, SIGNAL(clicked()), this, SLOT(affImportCSV()));

    affActiveElement(INDEX_EMPTY);
}

void MainWindow::affImportCSV() {
    if (!SaveCheck("importing affiliations from CSV file")) return;

    std::vector<std::string> properties;
    properties.push_back("Name");
    properties.push_back("Address");

    QImportDialog d(properties, this);
    if (QDialog::Accepted != d.exec()) return;

    std::string filename = d.GetFilename();
    if (!filename.empty()) {
        std::vector<int> choices = d.GetChoices();
        CSFParser csvData(filename,d.GetOffset(),d.RemoveWhitespaces());
        csvData.SetRecordSizeToMax();

        for (size_t i = 0;i<csvData.RecordCount();i++) {
            std::vector< std::string > csvRecord = csvData.GetRecord(i);
            Affiliation aff(choices[0]>= 0 ? csvRecord[choices[0]] : "",
                            choices[1]>= 0 ? csvRecord[choices[1]] : "");
            m_pConfDB->affiliations.AddUniqueEntry(aff);
        }

        conferenceDataChanged();
        UpdateUI();
    }
}

std::string AffiliationToString(const Affiliation* a) {
    if (a->GetAddress().empty())
        return a->GetName();
    else
        return a->GetName() + std::string(" - ") + a->GetAddress();
}

void MainWindow::UpdateAffUI(index_t newIndex) {
    std::vector< ElemListEntry > affList;
    for (size_t i = 0;i<m_pConfDB->affiliations.Count();++i) {
        affList.push_back( ElemListEntry(AffiliationToString(m_pConfDB->affiliations.GetEntryByPos(i)),
                                         m_pConfDB->affiliations.GetEntryByPos(i)->GetIndex(),
                                         m_pConfDB->affiliations.GetEntryByPos(i)->GetReferenceCount(m_pConfDB))  );
    }
    m_AffList->ElemUpdate(affList, newIndex);
}

// Slots

void MainWindow::affDataChanged() {    
    index_t index = m_AffList->GetActiveIndex();
    Affiliation* a = m_pConfDB->affiliations.GetEntryByIndex(index);

    a->SetName(std::string(m_AffNameEdit->text().toUtf8()));
    a->SetAddress(std::string(m_AffAddressEdit->text().toUtf8()));

    UpdateAffUI(index);
    UpdatePeopleUI();
}

void MainWindow::affNewElement(){
    Affiliation newAff("New","New");
    index_t index = m_pConfDB->affiliations.AddEntry(newAff);
    UpdateAffUI(index);
}

void MainWindow::affDelElement(index_t index){
    const Affiliation* a =  m_pConfDB->affiliations.GetEntryByIndex(index);
    assert(a);
    assert(a->GetReferenceCount(m_pConfDB) == 0);

    m_pConfDB->affiliations.RemoveEntryByIndex(index);
    UpdateAffUI(index);
}


void MainWindow::affReplaceElement(index_t index){
    const Affiliation* a =  m_pConfDB->affiliations.GetEntryByIndex(index);
    assert(a);

    QStringList items;
    for (size_t i = 0;i<m_pConfDB->affiliations.Count();++i) {
        const Affiliation* aff = m_pConfDB->affiliations.GetEntryByPos(i);

        if (aff->GetIndex() != a->GetIndex())
            items << QString::fromUtf8(AffiliationToString(aff).c_str());
    }

    if (items.count() == 0) {
        QMessageBox msgBox;
        msgBox.setIcon(QMessageBox::Warning);
        msgBox.setText("No additional rooms available.");
        msgBox.exec();
        return;
    }

    items.sort();

    bool ok;
    QString item = QInputDialog::getItem(this, tr("Select replacement Affiliation"),
                                         tr("Available Affiliations:"),
                                         items, 0, false, &ok);
    if (ok && !item.isEmpty()) {
        for (size_t i = 0;i<m_pConfDB->affiliations.Count();++i) {
            const Affiliation* aff = m_pConfDB->affiliations.GetEntryByPos(i);

            if (item == QString::fromUtf8(AffiliationToString(aff).c_str())) {
                m_pConfDB->affiliations.ReplaceIndexByEntry(index, *aff, m_pConfDB);
                UpdateAffUI(index);
                UpdatePeopleUI();
                conferenceDataChanged();
                break;
            }
        }

    }
}

void MainWindow::affActiveElement(index_t index){
    const Affiliation* a = m_pConfDB->affiliations.GetEntryByIndex(index);
    if (a) {
        m_AffNameEdit->setText(QString::fromUtf8(a->GetName().c_str()));
        m_AffAddressEdit->setText(QString::fromUtf8(a->GetAddress().c_str()));
        m_AffNameEdit->setEnabled(true);
        m_AffAddressEdit->setEnabled(true);
    } else {
        m_AffNameEdit->setText("");
        m_AffAddressEdit->setText("");
        m_AffNameEdit->setEnabled(false);
        m_AffAddressEdit->setEnabled(false);
    }
}
