#include "mainwindow.h"

void MainWindow::setupGeneralTab(){
    m_tabGeneral = new QWidget();
    m_tabGeneral->setObjectName(QString::fromUtf8("m_tabGeneral"));
    m_tabGeneral->setWindowTitle(QString::fromUtf8("General"));
    m_globalTabs->addTab(m_tabGeneral, m_tabGeneral->windowTitle());

    m_gridLayoutGeneral = new QGridLayout(m_tabGeneral);
    m_gridLayoutGeneral->setSpacing(6);
    m_gridLayoutGeneral->setContentsMargins(0, 0, 0, 0);
    m_gridLayoutGeneral->setObjectName(QString::fromUtf8("m_gridLayoutGeneral"));
    m_ConfNameLabel = new QLabel(m_tabGeneral);
    m_ConfNameLabel->setObjectName(QString::fromUtf8("m_ConfNameLabel"));
    m_ConfNameLabel->setText(QString::fromUtf8("Conference Name"));
    m_gridLayoutGeneral->addWidget(m_ConfNameLabel, 0, 0, 1, 1);

    m_ConfNameEdit = new QLineEdit(m_tabGeneral);
    m_ConfNameEdit->setObjectName(QString::fromUtf8("m_ConfNameEdit"));
    m_gridLayoutGeneral->addWidget(m_ConfNameEdit, 0, 2, 1, 1);

    m_ShortNameLabel = new QLabel(m_tabGeneral);
    m_ShortNameLabel->setObjectName(QString::fromUtf8("m_ShortNameLabel"));
    m_ShortNameLabel->setText(QString::fromUtf8("Short Name"));
    m_gridLayoutGeneral->addWidget(m_ShortNameLabel, 1, 0, 1, 1);

    m_ShortNameEdit = new QLineEdit(m_tabGeneral);
    m_ShortNameEdit->setObjectName(QString::fromUtf8("m_ShortNameEdit"));
    m_gridLayoutGeneral->addWidget(m_ShortNameEdit, 1, 2, 1, 1);

    m_ContactEmailLabel = new QLabel(m_tabGeneral);
    m_ContactEmailLabel->setObjectName(QString::fromUtf8("m_ContactEmailLabel"));
    m_ContactEmailLabel->setText(QString::fromUtf8("Contact Email"));
    m_gridLayoutGeneral->addWidget(m_ContactEmailLabel, 2, 0, 1, 1);

    m_ContactEmailEdit = new QLineEdit(m_tabGeneral);
    m_ContactEmailEdit->setObjectName(QString::fromUtf8("m_ContactEmailEdit"));
    m_gridLayoutGeneral->addWidget(m_ContactEmailEdit, 2, 2, 1, 1);

    m_WebUrlLabel = new QLabel(m_tabGeneral);
    m_WebUrlLabel->setObjectName(QString::fromUtf8("m_ConfNameLabel"));
    m_WebUrlLabel->setText(QString::fromUtf8("Webpage URL"));
    m_gridLayoutGeneral->addWidget(m_WebUrlLabel, 3, 0, 1, 1);

    m_WebUrlEdit = new QLineEdit(m_tabGeneral);
    m_WebUrlEdit->setObjectName(QString::fromUtf8("m_WebUrlEdit"));
    m_gridLayoutGeneral->addWidget(m_WebUrlEdit, 3, 2, 1, 1);

    m_NewsUrlLabel = new QLabel(m_tabGeneral);
    m_NewsUrlLabel->setObjectName(QString::fromUtf8("m_NewsUrlLabel"));
    m_NewsUrlLabel->setText(QString::fromUtf8("News URL"));
    m_gridLayoutGeneral->addWidget(m_NewsUrlLabel, 4, 0, 1, 1);

    m_NewsUrlEdit = new QLineEdit(m_tabGeneral);
    m_NewsUrlEdit->setObjectName(QString::fromUtf8("m_NewsUrlEdit"));
    m_gridLayoutGeneral->addWidget(m_NewsUrlEdit, 4, 2, 1, 1);

    m_TwitterNameLabel = new QLabel(m_tabGeneral);
    m_TwitterNameLabel->setObjectName(QString::fromUtf8("m_TwitterNameLabel"));
    m_TwitterNameLabel->setText(QString::fromUtf8("Twitter Name/Tag"));
    m_gridLayoutGeneral->addWidget(m_TwitterNameLabel, 5, 0, 1, 1);

    m_TwitterNameEdit = new QLineEdit(m_tabGeneral);
    m_TwitterNameEdit->setObjectName(QString::fromUtf8("m_TwitterNameEdit"));
    m_gridLayoutGeneral->addWidget(m_TwitterNameEdit, 5, 2, 1, 1);

    m_SupportsSessionMails = new QCheckBox(m_tabGeneral);
    m_SupportsSessionMails->setObjectName(QString::fromUtf8("m_SupportsSessionMails"));
    m_SupportsSessionMails->setText(QString::fromUtf8("Conference supports Emails to Session Chairs"));
    m_SupportsSessionMails->setChecked(true);
    m_gridLayoutGeneral->addWidget(m_SupportsSessionMails, 6, 2, 1, 1);

    m_verticalSpacerGeneral = new QSpacerItem(20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding);
    m_gridLayoutGeneral->addItem(m_verticalSpacerGeneral, 7, 0, 1, 1);

    QObject::connect(m_ConfNameEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_ConfNameEdit, SIGNAL(textEdited(QString)), this, SLOT(generalDataChanged()));
    QObject::connect(m_ShortNameEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_ShortNameEdit, SIGNAL(textEdited(QString)), this, SLOT(generalDataChanged()));
    QObject::connect(m_ContactEmailEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_ContactEmailEdit, SIGNAL(textEdited(QString)), this, SLOT(generalDataChanged()));

    QObject::connect(m_WebUrlEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_WebUrlEdit, SIGNAL(textEdited(QString)), this, SLOT(generalDataChanged()));
    QObject::connect(m_NewsUrlEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_NewsUrlEdit, SIGNAL(textEdited(QString)), this, SLOT(generalDataChanged()));
    QObject::connect(m_TwitterNameEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_TwitterNameEdit, SIGNAL(textEdited(QString)), this, SLOT(generalDataChanged()));

    QObject::connect(m_SupportsSessionMails, SIGNAL(clicked()), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_SupportsSessionMails, SIGNAL(clicked()), this, SLOT(generalDataChanged()));
}

void MainWindow::UpdateGeneralUI() {
    m_ConfNameEdit->setText(QString::fromUtf8(m_pConfDB->GetTitle().c_str()));
    m_ShortNameEdit->setText(QString::fromUtf8(m_pConfDB->GetShortTitle().c_str()));
    m_ContactEmailEdit->setText(QString::fromUtf8(m_pConfDB->GetContactMail().c_str()));
    m_WebUrlEdit->setText(QString::fromUtf8(m_pConfDB->GetWebUrl().c_str()));
    m_NewsUrlEdit->setText(QString::fromUtf8(m_pConfDB->GetNewsUrl().c_str()));
    m_TwitterNameEdit->setText(QString::fromUtf8(m_pConfDB->GetTwitterName().c_str()));
    m_SupportsSessionMails->setChecked(m_pConfDB->GetSupportsSessionMails());
}

void MainWindow::generalDataChanged() {
    m_pConfDB->SetTitle(std::string(m_ConfNameEdit->text().toUtf8()));
    m_pConfDB->SetShortTitle(std::string(m_ShortNameEdit->text().toUtf8()));
    m_pConfDB->SetContactMail(std::string(m_ContactEmailEdit->text().toUtf8()));

    m_pConfDB->SetWebUrl(std::string(m_WebUrlEdit->text().toUtf8()));
    m_pConfDB->SetNewsUrl(std::string(m_NewsUrlEdit->text().toUtf8()));
    m_pConfDB->SetTwitterName(std::string(m_TwitterNameEdit->text().toUtf8()));

    m_pConfDB->SetSupportsSessionMails(m_SupportsSessionMails->checkState() ==  Qt::Checked );
}
