#include "mainwindow.h"
#include <algorithm>
#include <QtGui/QMessageBox>
#include <QtGui/QInputDialog>
#include "QImportDialog.h"

#include "../../CrossPlatform/Paper.h"
#include "../../CrossPlatform/Poster.h"

void MainWindow::setupPublicationsTab(){
    m_tabPublications = new QWidget();
    m_tabPublications->setObjectName(QString::fromUtf8("m_tabPublications"));
    m_tabPublications->setWindowTitle(QString::fromUtf8("Publications"));
    m_globalTabs->addTab(m_tabPublications, m_tabPublications->windowTitle());

    m_PublicationGlobalLayout = new QHBoxLayout(m_tabPublications);
    m_PublicationGlobalLayout->setSpacing(6);
    m_PublicationGlobalLayout->setContentsMargins(0, 0, 0, 0);
    m_PublicationGlobalLayout->setObjectName(QString::fromUtf8("m_PublicationGlobalLayout"));
    m_PublicationSplitter = new QSplitter();
    m_PublicationGlobalLayout->addWidget(m_PublicationSplitter);

    m_PublicationListFrame = new QFrame(m_tabPublications);
    m_PublicationListFrame->setObjectName(QString::fromUtf8("m_PublicationListFrame"));
    m_PublicationListFrame->setFrameShape(QFrame::NoFrame);
    m_PublicationListFrame->setLineWidth(0);
    m_gridLayoutPublicationList = new QGridLayout(m_PublicationListFrame);
    m_gridLayoutPublicationList->setSpacing(6);
    m_gridLayoutPublicationList->setContentsMargins(0, 0, 0, 0);
    m_gridLayoutPublicationList->setObjectName(QString::fromUtf8("m_gridLayoutPublicationList"));
    m_PublicationImportBtn = new QPushButton(m_tabPublications);
    m_PublicationImportBtn->setText("Import Publications from CSV-File");
    m_gridLayoutPublicationList->addWidget(m_PublicationImportBtn, 0, 0, 1, 1);

    m_PublicationList = new QElemList(m_tabPublications, true);
    m_PublicationList->setObjectName(QString::fromUtf8("m_PublicationList"));
    m_gridLayoutPublicationList->addWidget(m_PublicationList, 1, 0, 1, 1);

    m_PublicationEditFrame = new QFrame(m_tabPublications);
    m_PublicationEditFrame->setObjectName(QString::fromUtf8("m_PublicationEditFrame"));
    m_PublicationEditFrame->setFrameShape(QFrame::NoFrame);
    m_PublicationEditFrame->setFrameShadow(QFrame::Raised);
    m_PublicationEditFrame->setLineWidth(0);
    m_gridLayoutPublication = new QGridLayout(m_PublicationEditFrame);
    m_gridLayoutPublication->setSpacing(6);
    m_gridLayoutPublication->setContentsMargins(0, 0, 0, 0);
    m_gridLayoutPublication->setObjectName(QString::fromUtf8("m_gridLayoutPublication"));

    m_PublicationTitleLabel = new QLabel(m_PublicationEditFrame);
    m_PublicationTitleLabel->setObjectName(QString::fromUtf8("m_PublicationTitleLabel"));
    m_PublicationTitleLabel->setText(QString::fromUtf8("Title"));
    m_gridLayoutPublication->addWidget(m_PublicationTitleLabel, 0, 0, 1, 1);
    m_PublicationTitleEdit = new QLineEdit(m_PublicationEditFrame);
    m_PublicationTitleEdit->setObjectName(QString::fromUtf8("m_PublicationTitleEdit"));
    m_gridLayoutPublication->addWidget(m_PublicationTitleEdit, 0, 1, 1, 1);
    m_PublicationAbstractLabel = new QLabel(m_PublicationEditFrame);
    m_PublicationAbstractLabel->setObjectName(QString::fromUtf8("m_PublicationAbstractLabel"));
    m_PublicationAbstractLabel->setText(QString::fromUtf8("Abstract"));
    m_PublicationAbstractLabel->setAlignment(Qt::AlignLeading|Qt::AlignLeft|Qt::AlignTop);
    m_gridLayoutPublication->addWidget(m_PublicationAbstractLabel, 1, 0, 1, 1);
    m_PublicationAbstractEdit = new QPlainTextEdit(m_PublicationEditFrame);
    m_PublicationAbstractEdit->setObjectName(QString::fromUtf8("m_PublicationAbstractEdit"));
    m_gridLayoutPublication->addWidget(m_PublicationAbstractEdit, 1, 1, 1, 1);
    m_PublicationPreviewURLLabel = new QLabel(m_PublicationEditFrame);
    m_PublicationPreviewURLLabel->setObjectName(QString::fromUtf8("m_PublicationPreviewURLLabel"));
    m_PublicationPreviewURLLabel->setText(QString::fromUtf8("Preview URL"));
    m_gridLayoutPublication->addWidget(m_PublicationPreviewURLLabel, 2, 0, 1, 1);
    m_PublicationPreviewURLEdit = new QLineEdit(m_PublicationEditFrame);
    m_PublicationPreviewURLEdit->setObjectName(QString::fromUtf8("m_PublicationPreviewURLEdit"));
    m_gridLayoutPublication->addWidget(m_PublicationPreviewURLEdit, 2, 1, 1, 1);
    m_PublicationPDFURLabel = new QLabel(m_PublicationEditFrame);
    m_PublicationPDFURLabel->setObjectName(QString::fromUtf8("m_PublicationPDFURLabel"));
    m_PublicationPDFURLabel->setText(QString::fromUtf8("PDF URL"));
    m_gridLayoutPublication->addWidget(m_PublicationPDFURLabel, 3, 0, 1, 1);
    m_PublicationPDFUREdit = new QLineEdit(m_PublicationEditFrame);
    m_PublicationPDFUREdit->setObjectName(QString::fromUtf8("m_PublicationPDFUREdit"));
    m_gridLayoutPublication->addWidget(m_PublicationPDFUREdit, 3, 1, 1, 1);
    m_PublicationURLLabel = new QLabel(m_PublicationEditFrame);
    m_PublicationURLLabel->setObjectName(QString::fromUtf8("m_PublicationURLLabel"));
    m_PublicationURLLabel->setText(QString::fromUtf8("Publication URL"));
    m_gridLayoutPublication->addWidget(m_PublicationURLLabel, 4, 0, 1, 1);
    m_PublicationURLEdit = new QLineEdit(m_PublicationEditFrame);
    m_PublicationURLEdit->setObjectName(QString::fromUtf8("m_PublicationURLEdit"));
    m_gridLayoutPublication->addWidget(m_PublicationURLEdit, 4, 1, 1, 1);

    m_PublicationAuthorsLabel = new QLabel(m_PublicationEditFrame);
    m_PublicationAuthorsLabel->setObjectName(QString::fromUtf8("m_PublicationAuthorsLabel"));
    m_PublicationAuthorsLabel->setText(QString::fromUtf8("Authors"));
    m_gridLayoutPublication->addWidget(m_PublicationAuthorsLabel, 5, 0, 1, 2);

    m_PublicationAuthorsList = new QElemList(m_PublicationEditFrame, false, false, true);
    m_PublicationAuthorsList->setObjectName(QString::fromUtf8("m_PublicationAuthorsList"));
    m_gridLayoutPublication->addWidget(m_PublicationAuthorsList, 6, 0, 1, 2);

    m_PublicationEditSpacer = new QSpacerItem(20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding);
    m_gridLayoutPublication->addItem(m_PublicationEditSpacer, 7, 0, 1, 1);

    m_PublicationSplitter->addWidget(m_PublicationListFrame);
    m_PublicationSplitter->addWidget(m_PublicationEditFrame);

    QObject::connect(m_PublicationTitleEdit, SIGNAL(textEdited(QString)), this, SLOT(publicationsDataChanged()));
    QObject::connect(m_PublicationTitleEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));

    QObject::connect(m_PublicationAbstractEdit, SIGNAL(textChanged()), this, SLOT(publicationsDataChanged()));
    QObject::connect(m_PublicationAbstractEdit, SIGNAL(textChanged()), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PublicationPreviewURLEdit, SIGNAL(textEdited(QString)), this, SLOT(publicationsDataChanged()));
    QObject::connect(m_PublicationPreviewURLEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PublicationPDFUREdit, SIGNAL(textEdited(QString)), this, SLOT(publicationsDataChanged()));
    QObject::connect(m_PublicationPDFUREdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PublicationURLEdit, SIGNAL(textEdited(QString)), this, SLOT(publicationsDataChanged()));
    QObject::connect(m_PublicationURLEdit, SIGNAL(textEdited(QString)), this, SLOT(conferenceDataChanged()));

    QObject::connect(m_PublicationList, SIGNAL(newElement()), this, SLOT(publicationsNewElement()));
    QObject::connect(m_PublicationList, SIGNAL(newElement()), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PublicationList, SIGNAL(delElement(index_t)), this, SLOT(publicationsDelElement(index_t)));
    QObject::connect(m_PublicationList, SIGNAL(delElement(index_t)), this, SLOT(conferenceDataChanged()));
    QObject::connect(m_PublicationList, SIGNAL(activeElement(index_t)), this, SLOT(publicationsActiveElement(index_t)));

    QObject::connect(m_PublicationAuthorsList, SIGNAL(newElement()), this, SLOT(publicationsAuthorNewElement()));
    QObject::connect(m_PublicationAuthorsList, SIGNAL(delElement(index_t)), this, SLOT(publicationsAuthorDelElement(index_t)));
    QObject::connect(m_PublicationAuthorsList, SIGNAL(upElement(index_t)), this, SLOT(publicationsAuthorUpElement(index_t)));
    QObject::connect(m_PublicationAuthorsList, SIGNAL(downElement(index_t)), this, SLOT(publicationsAuthorDownElement(index_t)));

    QObject::connect(m_PublicationImportBtn, SIGNAL(clicked()), this, SLOT(publicationsImportCSV()));

    publicationsActiveElement(INDEX_EMPTY);
}

void MainWindow::publicationsImportCSV() {
    if (!SaveCheck("importing publications from CSV file")) return;

    QMessageBox msgBox(QMessageBox::Question,tr("Publication type"), tr("What is the type of the publications that you want to import?"));
    QPushButton *paperButton = msgBox.addButton(tr("Papers"), QMessageBox::ActionRole);
    msgBox.addButton(tr("Posters"), QMessageBox::ActionRole);
    QPushButton *abortButton = msgBox.addButton(QMessageBox::Abort);

    msgBox.exec();
    if (msgBox.clickedButton() == abortButton) return;
    bool bPaper = msgBox.clickedButton() == paperButton;


    std::vector<std::string> properties;
    properties.push_back("Title");
    properties.push_back("Abstract");
    properties.push_back("Preview URL");
    properties.push_back("PDF URL");
    properties.push_back("Pubication URL");

    QImportDialog d(properties, this);
    if (QDialog::Accepted != d.exec()) return;

    std::string filename = d.GetFilename();
    if (!filename.empty()) {
        std::vector<int> choices = d.GetChoices();
        CSFParser csvData(filename,d.GetOffset(),d.RemoveWhitespaces());
        csvData.SetRecordSizeToMax();

        for (size_t i = 0;i<csvData.RecordCount();i++) {
            std::vector< std::string > csvRecord = csvData.GetRecord(i);

            if (bPaper) {
                Paper p(choices[0]>= 0 ? csvRecord[choices[0]] : "",
                        choices[1]>= 0 ? csvRecord[choices[1]] : "",
                        choices[2]>= 0 ? csvRecord[choices[2]] : "",
                        choices[3]>= 0 ? csvRecord[choices[3]] : "",
                        choices[4]>= 0 ? csvRecord[choices[4]] : "");
                m_pConfDB->works.AddUniqueEntry(p);
            } else {
                Poster p(choices[0]>= 0 ? csvRecord[choices[0]] : "",
                        choices[1]>= 0 ? csvRecord[choices[1]] : "",
                        choices[2]>= 0 ? csvRecord[choices[2]] : "",
                        choices[3]>= 0 ? csvRecord[choices[3]] : "",
                        choices[4]>= 0 ? csvRecord[choices[4]] : "");
                m_pConfDB->works.AddUniqueEntry(p);
            }
        }

        conferenceDataChanged();
        UpdateUI();
    }
}

void MainWindow::UpdatePublicationUI() {
    bool b = StartEditBlocker();
    UpdatePublicationUI(m_PublicationList->GetActiveIndex());
    EndEditBlocker(b);
}

void MainWindow::UpdatePublicationUI(index_t newIndex) {
    std::vector< ElemListEntry > PublicationList;
    for (size_t i = 0;i<m_pConfDB->works.Count();++i) {
        const SciWork* p = m_pConfDB->works.GetEntryByPos(i);

        const Paper* pa = dynamic_cast<const Paper*>(p);
        if (pa) {
            PublicationList.push_back( ElemListEntry(p->GetTitle() + std::string(" (Paper)"),
                                                     p->GetIndex(),
                                                     p->GetReferenceCount(m_pConfDB))  );
        } else {
            const Poster* po = dynamic_cast<const Poster*>(p);
            if (po) {
                PublicationList.push_back( ElemListEntry(p->GetTitle() + std::string(" (Poster)"),
                                                         p->GetIndex(),
                                                         p->GetReferenceCount(m_pConfDB))  );
            } else {
                PublicationList.push_back( ElemListEntry(p->GetTitle(),
                                                         p->GetIndex(),
                                                         p->GetReferenceCount(m_pConfDB))  );
            }
        }
    }
    m_PublicationList->ElemUpdate(PublicationList, newIndex);
    UpdatePublicationAuthorsList();
}


void MainWindow::UpdatePublicationUIEdits() {
   publicationsActiveElement(m_PublicationList->GetActiveIndex());
}

void MainWindow::UpdatePublicationAuthorsList() {
    UpdatePublicationAuthorsList(m_PublicationList->GetActiveIndex());
}

void MainWindow::UpdatePublicationAuthorsList(index_t index) {
    const SciWork* p =(m_pConfDB->works.GetEntryByIndex(index));

    std::vector< ElemListEntry > authorList;
    if (p) {
        for (size_t i = 0;i<p->GetAuthors().size();++i) {
            index_t pIndex = p->GetAuthors()[i];
            const SciPerson* pers = m_pConfDB->people.GetEntryByIndex(pIndex);
            authorList.push_back( ElemListEntry(pers->GetDisplayName(),
                                                pers->GetIndex()));
        }
    }
    m_PublicationAuthorsList->ElemUpdate(authorList, INDEX_EMPTY);
}

// slots

void MainWindow::publicationsDataChanged(){
    if (m_bEditBlockSignals) return;
    index_t PublicationIndex = m_PublicationList->GetActiveIndex();
    SciWork* p =(m_pConfDB->works.GetEntryByIndex(PublicationIndex));
    assert(p);

    p->SetTitle(std::string(m_PublicationTitleEdit->text().toUtf8()));
    p->SetAbstract(std::string(m_PublicationAbstractEdit->document()->toPlainText().toUtf8()));
    p->SetPreviewURL(std::string(m_PublicationPreviewURLEdit->text().toUtf8()));
    p->SetPDFURL(std::string(m_PublicationPDFUREdit->text().toUtf8()));
    p->SetURL(std::string(m_PublicationURLEdit->text().toUtf8()));

    UpdatePublicationUI(PublicationIndex);
    UpdateTalksUIEdits();
}

void MainWindow::publicationsNewElement() {
    QMessageBox msgBox(QMessageBox::Question,tr("Publication type"), tr("What type of publication do you want to add?"));
    QPushButton *paperButton = msgBox.addButton(tr("Paper"), QMessageBox::ActionRole);
    msgBox.addButton(tr("Poster"), QMessageBox::ActionRole);
    QPushButton *abortButton = msgBox.addButton(QMessageBox::Abort);

    msgBox.exec();
    if (msgBox.clickedButton() == abortButton) return;


    index_t index;
    if (msgBox.clickedButton() == paperButton) {
        Paper newPaper("New", "","","","");
        index = m_pConfDB->works.AddEntry(newPaper);
    } else {
        Poster newPoster("New", "","","","");
        index = m_pConfDB->works.AddEntry(newPoster);
    }
    UpdatePublicationUI(index);
    UpdateTalksUIEdits();
}

void MainWindow::publicationsDelElement(index_t index) {
    SciWork* p =(m_pConfDB->works.GetEntryByIndex(index));
    assert(p);
    assert(p->GetReferenceCount(m_pConfDB) == 0);

    m_pConfDB->works.RemoveEntryByIndex(index);
    UpdatePublicationUI(INDEX_EMPTY);
    UpdatePeopleUI();
}

void MainWindow::publicationsActiveElement(index_t index) {
    const SciWork* p =(m_pConfDB->works.GetEntryByIndex(index));
    bool b = StartEditBlocker();
    if (p) {
        m_PublicationTitleEdit->setText(QString::fromUtf8(p->GetTitle().c_str()));
        m_PublicationAbstractEdit->setPlainText(QString::fromUtf8(p->GetAbstract().c_str()));
        m_PublicationPreviewURLEdit->setText(QString::fromUtf8(p->GetPreviewURL().c_str()));
        m_PublicationPDFUREdit->setText(QString::fromUtf8(p->GetPDFURL().c_str()));
        m_PublicationURLEdit->setText(QString::fromUtf8(p->GetURL().c_str()));
        m_PublicationTitleEdit->setEnabled(true);
        m_PublicationAbstractEdit->setEnabled(true);
        m_PublicationPreviewURLEdit->setEnabled(true);
        m_PublicationPDFUREdit->setEnabled(true);
        m_PublicationURLEdit->setEnabled(true);
        m_PublicationAuthorsList->setEnabled(true);
        UpdatePublicationAuthorsList(index);
    } else {
        m_PublicationTitleEdit->setText("");
        m_PublicationAbstractEdit->clear();
        m_PublicationPreviewURLEdit->setText("");
        m_PublicationPDFUREdit->setText("");
        m_PublicationURLEdit->setText("");
        m_PublicationAuthorsList->Clear();
        m_PublicationTitleEdit->setEnabled(false);
        m_PublicationAbstractEdit->setEnabled(false);
        m_PublicationPreviewURLEdit->setEnabled(false);
        m_PublicationPDFUREdit->setEnabled(false);
        m_PublicationURLEdit->setEnabled(false);
        m_PublicationAuthorsList->setEnabled(false);
    }
    EndEditBlocker(b);
}

void MainWindow::publicationsAuthorNewElement() {
    QStringList items;
    index_t PublicationIndex = m_PublicationList->GetActiveIndex();
    SciWork* p =(m_pConfDB->works.GetEntryByIndex(PublicationIndex));
    assert(p);

    for (size_t i = 0;i<m_pConfDB->people.Count();++i) {
        const SciPerson* pers = m_pConfDB->people.GetEntryByPos(i);
        if (std::find(p->GetAuthors().begin(), p->GetAuthors().end(), pers->GetIndex()) == p->GetAuthors().end())
            items << QString::fromUtf8(pers->GetDisplayName().c_str());
    }

    if (items.count() == 0) {
        QMessageBox msgBox;
        msgBox.setIcon(QMessageBox::Warning);
        msgBox.setText("No additional authors available.");
        msgBox.exec();
        return;
    }

    items.sort();

    bool ok;
    QString item = QInputDialog::getItem(this, tr("Select Additional Authors"),
                                         tr("Authors:"), items, 0, false, &ok);
    if (ok && !item.isEmpty()) {
        for (size_t i = 0;i<m_pConfDB->people.Count();++i) {
            const SciPerson* pers = m_pConfDB->people.GetEntryByPos(i);
            if (item == QString::fromUtf8(pers->GetDisplayName().c_str())) {
                p->AddAuthor(*pers);
                break;
            }
        }

        UpdatePeopleUI();
        UpdatePublicationAuthorsList();
        conferenceDataChanged();
    }
}

void MainWindow::publicationsAuthorDelElement(index_t index) {
    index_t PublicationIndex = m_PublicationList->GetActiveIndex();
    SciWork* p =(m_pConfDB->works.GetEntryByIndex(PublicationIndex));
    assert(p);

    p->DelAuthor(index);
    UpdatePublicationAuthorsList();
    UpdatePeopleUI();
}

void MainWindow::publicationsAuthorUpElement(index_t index) {
    index_t PublicationIndex = m_PublicationList->GetActiveIndex();
    SciWork* p =(m_pConfDB->works.GetEntryByIndex(PublicationIndex));
    assert(p);

    p->UpAuthor(index);
    UpdatePublicationAuthorsList();
    UpdatePeopleUI();
}

void MainWindow::publicationsAuthorDownElement(index_t index) {
    index_t PublicationIndex = m_PublicationList->GetActiveIndex();
    SciWork* p =(m_pConfDB->works.GetEntryByIndex(PublicationIndex));
    assert(p);

    p->DownAuthor(index);
    UpdatePublicationAuthorsList();
    UpdatePeopleUI();
}
