#ifndef QELEMLIST_H
#define QELEMLIST_H

#include <QtGui/QWidget>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QToolButton>
#include <QtGui/QListWidget>
#include <QtGui/QLabel>
#include <QtGui/QFrame>
#include <QtGui/QSpacerItem>

#include <string>
#include <vector>

#include "../../CrossPlatform/ConferenceDB.h"

class ElemListEntry {
public:
    ElemListEntry(std::string title, index_t index, unsigned int refcount=0)
        : m_title(title),
          m_index(index),
          m_refcount(refcount) {}

    std::string m_title;
    index_t m_index;
    unsigned int m_refcount;
};

// TODO: add reorder buttons when sort is false
class QElemList : public QWidget
{
    Q_OBJECT

public:
    QElemList(QWidget *parent = 0, bool bSort=true, bool bCareAboutRefs=true, bool bReorderWidgets=false);
    ~QElemList();

    void ElemUpdate(const std::vector< ElemListEntry >& list, index_t newIndex);
    void SetActiveIndex(index_t newIndex);
    index_t GetActiveIndex();
    void Clear();

signals:
    void newElement();
    void delElement(index_t);
    void activeElement(index_t);
    void replaceElement(index_t);
    void upElement(index_t);
    void downElement(index_t);

private:
    QVBoxLayout *m_GlobalVerticalLayout;
    QListWidget *m_ElementListWidget;
    QFrame *m_ButtonFrame;
    QHBoxLayout *m_ButtonHorizontalLayout;
    QToolButton *m_DeleteToolButton;
    QToolButton *m_AddToolButton;
    QToolButton *m_DelUnrefToolButton;
    QToolButton *m_UpToolButton;
    QToolButton *m_DownToolButton;
    QLabel      *m_CountLabel;
    QSpacerItem *m_ButtonHorizontalSpacer;

    void setupUi();
    void UpdateListView();
    index_t GetActiveIndex(int iRow);

    int m_iLastRow;
    bool m_bDontEmitRowChange;
    std::vector< ElemListEntry > m_list;
    bool m_bSort;    
    bool m_bCareAboutRefs;
    bool m_bReorderWidgets;

private slots:
    void addButtonPressed();
    void delButtonPressed();
    void upButtonPressed();
    void downButtonPressed();
    void delUnrefButtonPressed();
    void currentRowChanged(int iRow);
};

#endif // QELEMLIST_H
