#include "QImportDialog.h"
#include <QtGui/QMessageBox>
#include <QtGui/QFileDialog>

#include "../../CrossPlatform/CSFParser.h"

QImportDialog::QImportDialog(const std::vector<std::string>& properties, QWidget *parent)
    : QDialog(parent),
      m_properties(properties)
{
}

QImportDialog::~QImportDialog()
{
}


int QImportDialog::exec() {
    m_filename = QFileDialog::getOpenFileName(this,"Please select a CSV-file", QString::null, "Comma seperated value file (*.csv *.txt)");

    if (m_filename.isEmpty())
        return 0;
    else {
        setupUi();
        return QDialog::exec();
    }
}

void QImportDialog::setupUi() {
    this->resize(500, 500);

    QSizePolicy sizePolicyEx(QSizePolicy::Preferred, QSizePolicy::Expanding);
    QSizePolicy sizePolicyMin(QSizePolicy::Preferred, QSizePolicy::Minimum);

    verticalLayout = new QVBoxLayout(this);
    verticalLayout->setSpacing(6);
    verticalLayout->setContentsMargins(11, 11, 11, 11);
    verticalLayout->setObjectName(QString::fromUtf8("verticalLayout"));
    groupBox_preview = new QGroupBox(this);
    groupBox_preview->setObjectName(QString::fromUtf8("groupBox_preview"));
    groupBox_preview->setTitle("Preview");

    groupBox_preview->setSizePolicy(sizePolicyEx);
    gridLayout = new QGridLayout(groupBox_preview);
    gridLayout->setSpacing(6);
    gridLayout->setContentsMargins(11, 11, 11, 11);
    gridLayout->setObjectName(QString::fromUtf8("gridLayout"));

    label_preview_Input = new QLabel(groupBox_preview);
    label_preview_Input->setObjectName(QString::fromUtf8("label_preview_Input"));
    label_preview_Input->setText("Input");
    label_preview_Input->setSizePolicy(sizePolicyMin);
    gridLayout->addWidget(label_preview_Input, 0, 0, 1, 1);

    plainTextEdit = new QPlainTextEdit(groupBox_preview);
    plainTextEdit->setObjectName(QString::fromUtf8("plainTextEdit"));
    plainTextEdit->setReadOnly(true);
    plainTextEdit->setSizePolicy(sizePolicyEx);
    QFile csvFile(m_filename);
    csvFile.open(QIODevice::ReadOnly);
    plainTextEdit->setPlainText(csvFile.readAll());
    csvFile.close();
    gridLayout->addWidget(plainTextEdit, 1, 0, 1, 2);

    label_preview_Output = new QLabel(groupBox_preview);
    label_preview_Output->setObjectName(QString::fromUtf8("label_preview_Output"));
    label_preview_Output->setText("Output");
    label_preview_Output->setSizePolicy(sizePolicyMin);
    gridLayout->addWidget(label_preview_Output, 2, 0, 1, 1);

    listWidget_preview = new QListWidget(groupBox_preview);
    listWidget_preview->setObjectName(QString::fromUtf8("listWidget_preview"));
    listWidget_preview->setSizePolicy(sizePolicyEx);
    gridLayout->addWidget(listWidget_preview, 3, 0, 1, 2);

    label_rowSkip = new QLabel(groupBox_preview);
    label_rowSkip->setObjectName(QString::fromUtf8("label_rowSkip"));
    label_rowSkip->setText("Skip Rows");
    label_rowSkip->setSizePolicy(sizePolicyMin);
    gridLayout->addWidget(label_rowSkip, 4, 0, 1, 1);

    spinBox_rowSkip = new QSpinBox(groupBox_preview);
    spinBox_rowSkip->setObjectName(QString::fromUtf8("spinBox_rowSkip"));
    spinBox_rowSkip->setMaximum(99999);
    spinBox_rowSkip->setSizePolicy(sizePolicyMin);
    gridLayout->addWidget(spinBox_rowSkip, 5, 0, 1, 1);

    checkBox_remWhitespace = new QCheckBox(groupBox_preview);
    checkBox_remWhitespace->setObjectName(QString::fromUtf8("checkBox_remWhitespace"));
    checkBox_remWhitespace->setText(QString::fromUtf8("Remove leading and trailing whitespaces"));
    gridLayout->addWidget(checkBox_remWhitespace, 5, 1, 1, 1);

    verticalLayout->addWidget(groupBox_preview);

    groupBox_setup = new QGroupBox(this);
    groupBox_setup->setObjectName(QString::fromUtf8("groupBox_setup"));
    groupBox_setup->setSizePolicy(sizePolicyMin);
    gridLayout_setup = new QGridLayout(groupBox_setup);
    gridLayout_setup->setSpacing(6);
    gridLayout_setup->setContentsMargins(11, 11, 11, 11);
    gridLayout_setup->setObjectName(QString::fromUtf8("gridLayout_setup"));

    label_property = new QLabel(groupBox_setup);
    label_property->setObjectName(QString::fromUtf8("label_property"));
    label_property->setText("Property");
    gridLayout_setup->addWidget(label_property, 0, 0, 1, 1);

    label_column = new QLabel(groupBox_setup);
    label_column->setObjectName(QString::fromUtf8("label_column"));
    label_column->setText("Column in CSV-File");
    gridLayout_setup->addWidget(label_column, 0, 1, 1, 1);

    checkBox_setup.resize(m_properties.size());
    spinBox_setup.resize(m_properties.size());
    for (size_t i = 0;i<m_properties.size();++i) {
        checkBox_setup[i] = new QCheckBox(groupBox_setup);
        checkBox_setup[i]->setObjectName(tr("checkBox_setup_%1").arg(i));
        checkBox_setup[i]->setText(QString::fromUtf8(m_properties[i].c_str()));
        gridLayout_setup->addWidget(checkBox_setup[i], i+1, 0, 1, 1);
        spinBox_setup[i] = new QSpinBox(groupBox_setup);
        spinBox_setup[i]->setObjectName(tr("spinBox_setup_%1").arg(i));
        spinBox_setup[i]->setMinimum(1);
        spinBox_setup[i]->setValue(1);
        gridLayout_setup->addWidget(spinBox_setup[i], i+1, 1, 1, 1);

        QObject::connect(checkBox_setup[i], SIGNAL(stateChanged(int)), this, SLOT(dataChanged()));
        QObject::connect(spinBox_setup[i], SIGNAL(valueChanged(int)), this, SLOT(dataChanged()));
    }
    verticalLayout->addWidget(groupBox_setup);

    frame_btn = new QFrame(this);
    frame_btn->setObjectName(QString::fromUtf8("frame_btn"));
    QSizePolicy sizePolicy2(QSizePolicy::Preferred, QSizePolicy::Minimum);
    sizePolicy2.setHorizontalStretch(0);
    sizePolicy2.setVerticalStretch(0);
    sizePolicy2.setHeightForWidth(frame_btn->sizePolicy().hasHeightForWidth());
    frame_btn->setSizePolicy(sizePolicy2);
    frame_btn->setFrameShape(QFrame::NoFrame);
    frame_btn->setFrameShadow(QFrame::Raised);
    frame_btn->setLineWidth(0);
    horizontalLayout = new QHBoxLayout(frame_btn);
    horizontalLayout->setSpacing(6);
    horizontalLayout->setContentsMargins(11, 11, 11, 11);
    horizontalLayout->setObjectName(QString::fromUtf8("horizontalLayout"));
    horizontalSpace_btn = new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
    horizontalLayout->addItem(horizontalSpace_btn);
    pushButton_OK = new QPushButton(frame_btn);
    pushButton_OK->setObjectName(QString::fromUtf8("pushButton_OK"));
    horizontalLayout->addWidget(pushButton_OK);
    pushButton_Cancel = new QPushButton(frame_btn);
    pushButton_Cancel->setObjectName(QString::fromUtf8("pushButton_Cancel"));
    horizontalLayout->addWidget(pushButton_Cancel);
    verticalLayout->addWidget(frame_btn);

    QObject::connect(pushButton_OK, SIGNAL(clicked()), this, SLOT(okPressed()));
    QObject::connect(pushButton_Cancel, SIGNAL(clicked()), this, SLOT(cancelPressed()));
    QObject::connect(spinBox_rowSkip, SIGNAL(valueChanged(int)), this, SLOT(dataChanged()));
    QObject::connect(checkBox_remWhitespace, SIGNAL(stateChanged(int)), this, SLOT(dataChanged()));

    this->setWindowTitle("Import Window");
    groupBox_setup->setTitle("Setup");
    pushButton_OK->setText("OK");
    pushButton_Cancel->setText("Cancel");

    checkInput();
}

bool QImportDialog::RemoveWhitespaces() {
    return checkBox_remWhitespace->isChecked();
}

void QImportDialog::checkInput() {
    CSFParser p(GetFilename(), GetOffset());
    p.SetRecordSizeToMax();

    if (p.RecordCount() < 2) {
        QMessageBox msgBox;
        msgBox.setIcon(QMessageBox::Information);
        msgBox.setText(tr("Only one line detected in the file! Maybe this is not a CSV File?"));
        msgBox.exec();
    }
}

std::vector<int> QImportDialog::GetChoices() {
    std::vector<int> choices;

    choices.resize(m_properties.size());
    for (size_t i = 0;i<m_properties.size();++i) {
        if (checkBox_setup[i]->isChecked()) {
            choices[i] = spinBox_setup[i]->value()-1;
        } else {
            choices[i] = -1;
        }
    }

    return choices;
}

std::string QImportDialog::GetFilename() {
    return std::string(m_filename.toUtf8());
}

unsigned int QImportDialog::GetOffset() {
    return spinBox_rowSkip->value();
}

void QImportDialog::okPressed() {
    accept();
}

void QImportDialog::cancelPressed() {
    m_properties.clear();
    m_filename.clear();
    close();
}

void QImportDialog::dataChanged() {
   for (size_t k = 0;k<m_properties.size();++k) {
       spinBox_setup[k]->setEnabled(checkBox_setup[k]->isChecked());
   }

   listWidget_preview->clear();

    CSFParser p(GetFilename(), GetOffset(), RemoveWhitespaces());
    p.SetRecordSizeToMax();

    for (size_t i = 0;i<p.RecordCount();i++) {
        QString line;
        std::vector< std::string > record = p.GetRecord(i);

        for (size_t k = 0;k<m_properties.size();++k) {
            for (size_t j = 0;j<record.size();++j) {

                spinBox_setup[k]->setEnabled(checkBox_setup[k]->isChecked());

                if (checkBox_setup[k]->isChecked() && int(j) == spinBox_setup[k]->value()-1) {
                    if (line.isEmpty())
                        line = tr("%1=\"%2\"").arg(m_properties[k].c_str()).arg(record[j].c_str());
                    else
                        line = tr("%1 %2=\"%3\"").arg(line).arg(m_properties[k].c_str()).arg(record[j].c_str());
                }
            }
        }

        if (!line.isEmpty())
            listWidget_preview->addItem(line);
    }
}
