#include "QMailDialog.h"

#include <QtCore/QTextStream>

QMailDialog::QMailDialog(QWidget *parent)
    : QDialog(parent)
{
    setupUi();
}

QMailDialog::~QMailDialog()
{
}

void QMailDialog::setupUi() {
    this->resize(500, 300);

    QSizePolicy sizePolicyEx(QSizePolicy::Preferred, QSizePolicy::Expanding);
    QSizePolicy sizePolicyMin(QSizePolicy::Preferred, QSizePolicy::Minimum);

    verticalLayout = new QVBoxLayout(this);
    verticalLayout->setSpacing(6);
    verticalLayout->setContentsMargins(11, 11, 11, 11);
    verticalLayout->setObjectName(QString::fromUtf8("verticalLayout"));

    groupBox_params = new QGroupBox(this);
    groupBox_params->setObjectName(QString::fromUtf8("groupBox_params"));
    groupBox_params->setTitle("Parameter");
    groupBox_params->setSizePolicy(sizePolicyMin);
    gridLayoutParams = new QGridLayout(groupBox_params);
    gridLayoutParams->setSpacing(6);
    gridLayoutParams->setContentsMargins(11, 11, 11, 11);
    gridLayoutParams->setObjectName(QString::fromUtf8("gridLayoutParams"));

    label_MailCommand = new QLabel(groupBox_params);
    label_MailCommand->setObjectName(QString::fromUtf8("label_MailCommand"));
    label_MailCommand->setText("Mail Command");
    label_MailCommand->setSizePolicy(sizePolicyMin);
    gridLayoutParams->addWidget(label_MailCommand, 0, 0, 1, 1);
    textEdit_MailCommand = new QLineEdit(groupBox_params);
    textEdit_MailCommand->setObjectName(QString::fromUtf8("textEdit_MailCommand"));
    textEdit_MailCommand->setSizePolicy(sizePolicyMin);
    textEdit_MailCommand->setText("./sendEmail");
    gridLayoutParams->addWidget(textEdit_MailCommand, 0, 1, 1, 1);

    label_FromParam = new QLabel(groupBox_params);
    label_FromParam->setObjectName(QString::fromUtf8("label_FromParam"));
    label_FromParam->setText("\"From\" Parameter");
    label_FromParam->setSizePolicy(sizePolicyMin);
    gridLayoutParams->addWidget(label_FromParam, 1, 0, 1, 1);
    textEdit_FromParam = new QLineEdit(groupBox_params);
    textEdit_FromParam->setObjectName(QString::fromUtf8("textEdit_FromParam"));
    textEdit_FromParam->setSizePolicy(sizePolicyMin);
    textEdit_FromParam->setText("-f");
    gridLayoutParams->addWidget(textEdit_FromParam, 1, 1, 1, 1);

    label_ToParam = new QLabel(groupBox_params);
    label_ToParam->setObjectName(QString::fromUtf8("label_ToParam"));
    label_ToParam->setText("\"To\" Parameter");
    label_ToParam->setSizePolicy(sizePolicyMin);
    gridLayoutParams->addWidget(label_ToParam, 2, 0, 1, 1);
    textEdit_ToParam = new QLineEdit(groupBox_params);
    textEdit_ToParam->setObjectName(QString::fromUtf8("textEdit_ToParam"));
    textEdit_ToParam->setSizePolicy(sizePolicyMin);
    textEdit_ToParam->setText("-t");
    gridLayoutParams->addWidget(textEdit_ToParam, 2, 1, 1, 1);

    label_SubjectParam = new QLabel(groupBox_params);
    label_SubjectParam->setObjectName(QString::fromUtf8("label_SubjectParam"));
    label_SubjectParam->setText("\"Subject\" Parameter");
    label_SubjectParam->setSizePolicy(sizePolicyMin);
    gridLayoutParams->addWidget(label_SubjectParam, 3, 0, 1, 1);
    textEdit_SubjectParam = new QLineEdit(groupBox_params);
    textEdit_SubjectParam->setObjectName(QString::fromUtf8("textEdit_SubjectParam"));
    textEdit_SubjectParam->setSizePolicy(sizePolicyMin);
    textEdit_SubjectParam->setText("-u");
    gridLayoutParams->addWidget(textEdit_SubjectParam, 3, 1, 1, 1);

    label_BodyParam = new QLabel(groupBox_params);
    label_BodyParam->setObjectName(QString::fromUtf8("label_BodyParam"));
    label_BodyParam->setText("\"Mail Body\" Parameter");
    label_BodyParam->setSizePolicy(sizePolicyMin);
    gridLayoutParams->addWidget(label_BodyParam, 4, 0, 1, 1);
    textEdit_BodyParam = new QLineEdit(groupBox_params);
    textEdit_BodyParam->setObjectName(QString::fromUtf8("textEdit_BodyParam"));
    textEdit_BodyParam->setSizePolicy(sizePolicyMin);
    textEdit_BodyParam->setText("-m");
    gridLayoutParams->addWidget(textEdit_BodyParam, 4, 1, 1, 1);

    label_SupplParam = new QLabel(groupBox_params);
    label_SupplParam->setObjectName(QString::fromUtf8("label_SupplParam"));
    label_SupplParam->setText("Additional Parameters");
    label_SupplParam->setSizePolicy(sizePolicyMin);
    gridLayoutParams->addWidget(label_SupplParam, 5, 0, 1, 1);
    textEdit_SupplParam = new QLineEdit(groupBox_params);
    textEdit_SupplParam->setObjectName(QString::fromUtf8("textEdit_SupplParam"));
    textEdit_SupplParam->setSizePolicy(sizePolicyMin);
    textEdit_SupplParam->setText("-s smtp.myserver.com");
    gridLayoutParams->addWidget(textEdit_SupplParam, 5, 1, 1, 1);
    verticalLayout->addWidget(groupBox_params);

    groupBox_preview = new QGroupBox(this);
    groupBox_preview->setObjectName(QString::fromUtf8("groupBox_preview"));
    groupBox_preview->setTitle("Preview");
    groupBox_preview->setSizePolicy(sizePolicyEx);
    gridLayoutPreview = new QGridLayout(groupBox_preview);
    gridLayoutPreview->setSpacing(6);
    gridLayoutPreview->setContentsMargins(11, 11, 11, 11);
    gridLayoutPreview->setObjectName(QString::fromUtf8("gridLayoutPreview"));

    preview = new QPlainTextEdit(groupBox_preview);
    preview->setObjectName(QString::fromUtf8("preview"));
    preview->setReadOnly(true);
    preview->setSizePolicy(sizePolicyEx);
    gridLayoutPreview->addWidget(preview, 0, 0, 1, 1);

    verticalLayout->addWidget(groupBox_preview);

    frame_btn = new QFrame(this);
    frame_btn->setObjectName(QString::fromUtf8("frame_btn"));
    frame_btn->setFrameShape(QFrame::NoFrame);
    frame_btn->setFrameShadow(QFrame::Raised);
    frame_btn->setLineWidth(0);
    frame_btn->setSizePolicy(sizePolicyMin);
    horizontalBtnLayout = new QHBoxLayout(frame_btn);
    horizontalBtnLayout->setSpacing(6);
    horizontalBtnLayout->setContentsMargins(11, 11, 11, 11);
    horizontalBtnLayout->setObjectName(QString::fromUtf8("horizontalBtnLayout"));
    horizontalSpace_btn = new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
    horizontalBtnLayout->addItem(horizontalSpace_btn);
    pushButton_OK = new QPushButton(frame_btn);
    pushButton_OK->setObjectName(QString::fromUtf8("pushButton_OK"));
    horizontalBtnLayout->addWidget(pushButton_OK);
    pushButton_Cancel = new QPushButton(frame_btn);
    pushButton_Cancel->setObjectName(QString::fromUtf8("pushButton_Cancel"));
    horizontalBtnLayout->addWidget(pushButton_Cancel);
    verticalLayout->addWidget(frame_btn);

    QObject::connect(pushButton_OK, SIGNAL(clicked()), this, SLOT(okPressed()));
    QObject::connect(pushButton_Cancel, SIGNAL(clicked()), this, SLOT(cancelPressed()));
    QObject::connect(textEdit_MailCommand, SIGNAL(textEdited(QString)), this, SLOT(dataChanged()));
    QObject::connect(textEdit_FromParam, SIGNAL(textEdited(QString)), this, SLOT(dataChanged()));
    QObject::connect(textEdit_ToParam, SIGNAL(textEdited(QString)), this, SLOT(dataChanged()));
    QObject::connect(textEdit_SubjectParam, SIGNAL(textEdited(QString)), this, SLOT(dataChanged()));
    QObject::connect(textEdit_BodyParam, SIGNAL(textEdited(QString)), this, SLOT(dataChanged()));
    QObject::connect(textEdit_SupplParam, SIGNAL(textEdited(QString)), this, SLOT(dataChanged()));

    this->setWindowTitle("Email Parameter Window");
    pushButton_OK->setText("OK");
    pushButton_Cancel->setText("Cancel");

    dataChanged();
}

void QMailDialog::okPressed() {
    accept();
}

void QMailDialog::cancelPressed() {
    close();
}

void QMailDialog::dataChanged() {
    QString str;
    QTextStream out(&str);
    out << GetMailCommand() << " "
        << GetSupplParam() << " "
        << GetFromParam() << " \"from@mail.com\" "
        << GetSubjectParam() << " \"email subject\" "
        << GetToParam() << " \"to@mail.com\" "
        << GetBodyParam() << " \"Dear author, ...\"";

    preview->setPlainText(str);
}
