#ifndef QMAILDIALOG_H
#define QMAILDIALOG_H

#include <QtGui/QDialog>
#include <QtGui/QFrame>
#include <QtGui/QGridLayout>
#include <QtGui/QGroupBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QSpacerItem>
#include <QtGui/QPlainTextEdit>

#include <string>
#include <vector>

class QMailDialog : public QDialog
{
    Q_OBJECT

public:
    QMailDialog(QWidget *parent = 0);
    ~QMailDialog();

    QString GetMailCommand() {return textEdit_MailCommand->text().toUtf8();}
    QString GetFromParam() {return textEdit_FromParam->text().toUtf8();}
    QString GetToParam() {return textEdit_ToParam->text().toUtf8();}
    QString GetSubjectParam() {return textEdit_SubjectParam->text().toUtf8();}
    QString GetBodyParam() {return textEdit_BodyParam->text().toUtf8();}
    QString GetSupplParam() {return textEdit_SupplParam->text().toUtf8();}


private slots:
    void okPressed();
    void cancelPressed();
    void dataChanged();

private:
    QVBoxLayout *verticalLayout;

    QGroupBox *groupBox_params;
    QGridLayout *gridLayoutParams;
    QLabel*     label_MailCommand;
    QLineEdit*  textEdit_MailCommand;
    QLabel*     label_FromParam;
    QLineEdit*  textEdit_FromParam;
    QLabel*     label_ToParam;
    QLineEdit*  textEdit_ToParam;
    QLabel*     label_SubjectParam;
    QLineEdit*  textEdit_SubjectParam;
    QLabel*     label_BodyParam;
    QLineEdit*  textEdit_BodyParam;
    QLabel*  label_SupplParam;
    QLineEdit*  textEdit_SupplParam;

    QGroupBox *groupBox_preview;
    QGridLayout *gridLayoutPreview;
    QPlainTextEdit *preview;

    QFrame*      frame_btn;
    QHBoxLayout *horizontalBtnLayout;
    QSpacerItem *horizontalSpace_btn;
    QPushButton *pushButton_OK;
    QPushButton *pushButton_Cancel;

    void setupUi();
};

#endif // QMAILDIALOG_H
